% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_sequential_analysis.R
\name{DoSA}
\alias{DoSA}
\title{Sequential analysis.}
\usage{
DoSA(
  data = NULL,
  source = NULL,
  time = NULL,
  n = NULL,
  es = NULL,
  se = NULL,
  r1 = NULL,
  m1 = NULL,
  sd1 = NULL,
  n1 = NULL,
  r2 = NULL,
  m2 = NULL,
  sd2 = NULL,
  n2 = NULL,
  group = c("Group 1", "Group 2"),
  prefer = "small",
  measure = "ES",
  model = "random",
  method = "DL",
  alpha = 0.05,
  beta = 0.2,
  AES = NULL,
  plot = FALSE
)
}
\arguments{
\item{data}{DATAFRAME consists of relevant information.}

\item{source}{CHARACTER for labeling the included data sets.}

\item{time}{NUMERIC values of time sequence.}

\item{n}{INTEGER values of sample sizes.}

\item{es}{NUMERIC values of effect sizes.}

\item{se}{NUMERIC values of standard errors for the effect sizes.}

\item{r1}{INTEGER values of observed events in group 1 in the included data.}

\item{m1}{NUMERIC values of estimated means in group 1 in the included data.}

\item{sd1}{NUMERIC values of standard deviations in group 1 in the
included data.}

\item{n1}{INTEGER values of sample sizes in group 1 in the included data.}

\item{r2}{INTEGER values of observed events in group 2 in the included data.}

\item{m2}{NUMERIC values of estimated means in group 2 in the included data.}

\item{sd2}{NUMERIC values of standard deviations in group 2 in the
included data.}

\item{n2}{INTEGER values of sample sizes in group 2 in the included data.}

\item{group}{CHARACTER for labeling two groups.}

\item{prefer}{CHARACTER of "small" and "large" for indicating which direction
is beneficial effect in statistic test.}

\item{measure}{CHARACTER for indicating which statistic measure should be used.}

\item{model}{CHARACTER of "random" and "fixed" for indicating whether
to use random-effects model or fixed-effect model.}

\item{method}{CHARACTER for indicating which estimator should be used in
random-effects model.}

\item{alpha}{NUMERIC value between 0 to 1 for indicating the assumed type I
error.}

\item{beta}{NUMERIC value between 0 to 1 for indicating the assumed type II
error.}

\item{AES}{NUMERIC value for indicating the assumed meaningful effect size.}

\item{plot}{LOGIC value for indicating whether to illustrate proportion of
excessive cases plot.}
}
\value{
\strong{DoSA()} returns a summary on the result of sequential analysis.
}
\description{
\strong{DoSA()} is a function for conducting sequential analysis.
}
\examples{
## Not run:
# 1. Import a dataset of study by Fleiss (1993)
library(meta)
data("Fleiss1993cont")

# 2. Perform sequential analysis
 output <- DoSA(Fleiss1993cont, study, year,
                m1 = mean.psyc, sd1 = sd.psyc, n1 = n.psyc,
                m2 = mean.cont, sd2 = sd.cont, n2 = n.cont,
                measure = "SMD", AES = 0.5,
                group = c("Psychotherapy", "Control"), plot = TRUE)

## End(Not run)

}
\references{
Jennison, C., & Turnbull, B. W. (2005). Meta-analyses and adaptive group
sequential designs in the clinical development process.
\strong{Journal of biopharmaceutical statistics}, \emph{15(4)}, 537–558.
https://doi.org/10.1081/BIP-200062273.

Wetterslev, J., Jakobsen, J. C., & Gluud, C. (2017). Trial sequential analysis
in systematic reviews with meta-analysis. \strong{BMC medical research methodology},
\emph{17(1)}, 1-18.

NCSS Statistical Software (2023). \strong{Group-sequential analysis for two proportions}.
In \emph{PASS Documentation}. Available online:
https://www.ncss.com/wp-content/themes/ncss/pdf/Procedures/NCSS/Group-Sequential_Analysis_for_Two_Proportions.pdf
}
\seealso{
\code{\link{TestDisparity}}, \code{\link{TestDiscordance}}
}
\author{
Enoch Kang
}
