% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.aedseo}
\alias{predict.aedseo}
\title{Predict Growth Rates for Future Time Steps}
\usage{
\method{predict}{aedseo}(object, n_step = 3, ...)
}
\arguments{
\item{object}{A model object created using the \code{aedseo} package, typically
the result of the \code{aedseo()} function.}

\item{n_step}{An integer specifying the number of future time steps for
which you want to predict growth rates. Default is 3.}

\item{...}{Additional arguments (not used).}
}
\value{
A tibble S3 object called \code{aedseo} containing the predicted growth
rates, including time, estimated growth rate, lower confidence interval,
and upper confidence interval for the specified number of future time steps.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function is used to predict future growth rates based on a model object
created using the 'aedseo' package. It takes the model object and the number
of future time steps (\code{n_step}) for which you want to make predictions and
returns a prediction tibble.
}
\examples{
# Analyze the data using the aedseo package
tsd_data <- tsd(
  observed = c(100, 120, 150, 180, 220, 270),
  time = as.Date(c(
    "2023-01-01",
    "2023-01-02",
    "2023-01-03",
    "2023-01-04",
    "2023-01-05",
    "2023-01-06"
  )),
  time_interval = "day"
)

aedseo_results <- aedseo(
  tsd = tsd_data,
  k = 3,
  level = 0.95,
  family = "poisson"
)

# Predict growth rates for the next 5 time steps
prediction <- predict(object = aedseo_results, n_step = 5)

# Print the prediction
print(prediction)

}
