
<!-- README.md is generated from README.Rmd. Please edit that file -->

# aeddo <img src="man/figures/logo.png" align="right" height="139" alt="" />

<!-- badges: start -->

[![CRAN
status](https://www.r-pkg.org/badges/version/aeddo)](https://CRAN.R-project.org/package=aeddo)
[![R-CMD-check](https://github.com/ssi-dk/aeddo/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/ssi-dk/aeddo/actions/workflows/R-CMD-check.yaml)
[![Codecov test
coverage](https://codecov.io/gh/ssi-dk/aeddo/branch/main/graph/badge.svg)](https://app.codecov.io/gh/ssi-dk/aeddo?branch=main)
[![Lifecycle:
stable](https://img.shields.io/badge/lifecycle-stable-brightgreen.svg)](https://lifecycle.r-lib.org/articles/stages.html#stable)
<!-- badges: end -->

## aeddo: Automated and Early Detection of Disease Outbreaks

aeddo is an R package that provides a cutting-edge solution for the
automated and early detection of disease outbreaks in time series data.
This innovative tool leverages hierarchical models in a novel way to
infer one-step ahead random effects, which are subsequently used to
identify and characterize disease outbreaks.

## Why aeddo?

Epidemiologists, public health professionals, and researchers are often
challenged by the need to detect disease outbreaks promptly. Timely
identification is critical for implementing appropriate control measures
and mitigating the impact of outbreaks. aeddo is designed to address
this challenge and offer a range of benefits:

- **Innovative Approach**: aeddo employs hierarchical models to estimate
  one-step ahead random effects, enabling early detection of outbreaks
  in disease data. This approach is a game-changer in epidemiological
  analysis.
- **Effectively Controls False Alarms**: aeddo’s applications are broad
  and relevant across the field of epidemiology. It supports
  professionals and researchers in various domains, including public
  health, epidemiological research, and data analysis, while effectively
  controlling the number of false alarms.
- **Real-time Insights**: By providing prospective detection
  capabilities, aeddo offers real-time insights into disease outbreak
  patterns. This is invaluable for making data-driven decisions and
  implementing timely interventions.

## Installation

``` r
# Install aeddo from CRAN
install.packages("aeddo")
```

### Development version

You can install the development version of `aeddo` from
[GitHub](https://github.com/) with:

``` r
# install.packages("devtools")
devtools::install_github("ssi-dk/aeddo")
```

Start leveraging aeddo today to gain a unique perspective on disease
outbreak detection in your time series data.

## Get Started

Explore the package’s functions and features by referring to the
documentation. Detailed examples and use cases are provided to help you
make the most of aeddo in your epidemiological work.

## Contributions

Contributions to aeddo are welcomed. If you have suggestions, feature
requests, or encounter issues, please don’t hesitate to open an
[issue](https://github.com/ssi-dk/aeddo/issues) or submit a [pull
request](https://github.com/ssi-dk/aeddo/pulls).
