% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prior.R
\docType{class}
\name{Prior-class}
\alias{Prior-class}
\alias{Prior}
\title{Univariate prior on model parameter}
\description{
A \code{Prior} object represents a prior distribution on the single model
parameter of a \code{\link{DataDistribution}} class
object.
Together a prior and data-distribution specify the class of the joint
distribution of the test statisic, X, and its parameter, theta.
Currently, \pkg{adoptr} only allows simple models with a single parameter.
Implementations for \link{PointMassPrior} and \link{ContinuousPrior} are available.
}
\details{
For an example on working with priors, see
   \href{https://kkmann.github.io/adoptr/articles/working-with-priors.html}{here}.
}
\examples{
disc_prior <- PointMassPrior(c(0.1, 0.25), c(0.4, 0.6))

cont_prior <- ContinuousPrior(
  pdf     = function(x) dnorm(x, mean = 0.3, sd = 0.2),
  support = c(-2, 3)
)


}
\seealso{
For the available methods, see \code{\link{bounds}},
  \code{\link{expectation}}, \code{\link{condition}}, \code{\link{predictive_pdf}},
  \code{\link{predictive_cdf}}, \code{\link{posterior}}
}
