% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04fileOperations.r
\docType{methods}
\name{adf.file.exists}
\alias{adf.file.exists}
\alias{adf.file.exists,amigaDisk,character-method}
\title{Test file or directory existsence in an amigaDisk object}
\usage{
\S4method{adf.file.exists}{amigaDisk,character}(x, file)
}
\arguments{
\item{x}{An \code{\link{amigaDisk}} object in which this method
will check for the file's existence.}

\item{file}{A \code{character} string representing a file or directory name.
Use Amiga specifications for file name (see \code{\link{current.adf.dir}}).}
}
\value{
Returns a \code{logical} value indicating whether the file exists
or not.
}
\description{
Tests whether a specific file (or directory) exists in an
\code{\link{amigaDisk}} object.
}
\details{
This method will look for a file/directory header, based on its name.
If such a header exists, it is assumed that the file exists. The
file/directory itself is not checked for validity.
}
\examples{
data(adf.example)

## This file exists:
adf.file.exists(adf.example, "df0:mods/mod.intro")

## This file doesn't:
adf.file.exists(adf.example, "df0:idontexist")
}
\author{
Pepijn de Vries
}
