% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windowSmooth.R
\name{windowSmooth}
\alias{windowSmooth}
\title{Fast Computation of Moving Window Average}
\usage{
windowSmooth(x, W, x.fs = 1)
}
\arguments{
\item{x}{A numeric vector. A time-series for which a moving window average is computed.}

\item{W}{A numeric scalar. A length of a moving window, expressed in time (seconds).}

\item{x.fs}{Frequency of a time-series \code{x}, expressed in a number of observations
per second. Defaults to \code{1}.}
}
\value{
A numeric vector. Moving window average of a time-series \code{x}. Note:
head and tail of the
output vector where the moving window is undefined are filled with \code{NA}.
}
\description{
Compute moving window average of a time-series \code{x}.
}
\details{
Time-series frequency \code{x.fs} and a length  of a moving window (expressed in time) \code{W}
together determine
\code{W.vl = round(W * x.fs)}, a length of a moving window expressed in a length of
\code{x} vector object.
Note: \code{W.vl} must be equal or greater than \code{3}.
\itemize{
  \item If \code{W.vl < 3} then an error is thrown.
  \item If \code{W.vl} is an even number then \code{(W.vl-1)} value is silently
  used instead as a length of a moving window expressed in \code{x} vector length.
}
}
\examples{
## Time-series defined as a function f(x) = x
N <- 100
W  <- 20
x <- 1:N
x.smoothed <- windowSmooth(x, W)
plot(x, type = "l")
points(x.smoothed, col = "red")

## Time-series defined as a function f(x) = sin(x) + noise
N <-  1000
W  <- 100
x <- sin(seq(0, 4 * pi, length.out = N)) + rnorm(N, sd = 0.1)
x.smoothed <- windowSmooth(x, W)
plot(x, type = "l")
points(x.smoothed, col = "red")

}
