% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/strataMethods.R
\docType{methods}
\name{strata}
\alias{addStrata}
\alias{addStrata,genind-method}
\alias{addStrata,genlight-method}
\alias{addStrata<-}
\alias{addStrata<-,genind-method}
\alias{addStrata<-,genlight-method}
\alias{nameStrata}
\alias{nameStrata,genind-method}
\alias{nameStrata,genlight-method}
\alias{nameStrata<-}
\alias{nameStrata<-,genind-method}
\alias{nameStrata<-,genlight-method}
\alias{splitStrata}
\alias{splitStrata,genind-method}
\alias{splitStrata,genlight-method}
\alias{splitStrata<-}
\alias{splitStrata<-,genind-method}
\alias{splitStrata<-,genlight-method}
\alias{strata}
\alias{strata,genind-method}
\alias{strata,genlight-method}
\alias{strata<-}
\alias{strata<-,genind-method}
\alias{strata<-,genlight-method}
\title{Access and manipulate the population strata for genind or genlight objects.}
\usage{
strata(x, formula = NULL, combine = TRUE, value)

strata(x) <- value

nameStrata(x, value)

nameStrata(x) <- value

splitStrata(x, value, sep = "_")

splitStrata(x, sep = "_") <- value

addStrata(x, value, name = "NEW")

addStrata(x, name = "NEW") <- value
}
\arguments{
\item{x}{a genind or genlight object}

\item{formula}{a nested formula indicating the order of the population
strata.}

\item{combine}{if \code{TRUE} (default), the levels will be combined according to the
formula argument. If it is \code{FALSE}, the levels will not be combined.}

\item{value}{a data frame OR vector OR formula (see details).}

\item{sep}{a \code{character} indicating the character used to separate
hierarchical levels. This defaults to "_".}

\item{name}{an optional name argument for use with addStrata if supplying
a vector. Defaults to "NEW".}
}
\description{
The following methods allow the user to quickly change the strata of a genind
or genlight object.
}
\details{
\subsection{Function Specifics}{ \itemize{ \item \strong{strata()} -
  Use this function to view or define population stratification of a
  \linkS4class{genind} or \linkS4class{genlight} object. \item
  \strong{nameStrata()} - View or rename the different levels of strata.
  \item \strong{splitStrata()} - Split strata that are combined with a common
  separator. This function should only be used once during a workflow.
  \itemize{ \item \emph{Rationale:} It is often difficult to import files
  with several levels of strata as most data formats do not allow unlimited
  population levels. This is circumvented by collapsing all population strata
  into a single population factor with a common separator for each
  observation. } \item \strong{addStrata()} - Add levels to your population
  strata. This is ideal for adding groups defined by
  \code{\link{find.clusters}}. You can input a data frame or a vector, but if
  you put in a vector, you have the option to name it. }}

  \subsection{Argument Specifics}{

  These functions allow the user to seamlessly carry all possible population
  stratification with their \linkS4class{genind} or \linkS4class{genlight}
  object. Note that there are two ways of performing all methods: \itemize{
  \item modifying: \code{strata(myData) <- myStrata} \item preserving:
  \code{myNewData <- strata(myData, value = myStrata)} } They essentially do
  the same thing except that the modifying assignment method (the one with
  the "\code{<-}") will modify the object in place whereas the non-assignment
  method will preserve the original object (unless you overwrite it). Due to
  convention, everything right of the assignment is termed \code{value}. To
  avoid confusion, here is a guide to the argument \strong{\code{value}} for
  each function: \itemize{ \item \strong{strata()} \code{value = }a
  \code{\link{data.frame}} that defines the strata for each individual in the
  rows. \item \strong{nameStrata()} \code{value = }a \code{\link{vector}} or
  a \code{\link{formula}} that will define the names. \item
  \strong{splitStrata()} \code{value = }a \code{\link{formula}} argument with
  the same number of levels as the strata you wish to split. \item
  \strong{addStrata()} \code{value = }a \code{\link{vector}} or
  \code{\link{data.frame}} with the same length as the number of individuals
  in your data. }}

  \subsection{Details on Formulas}{

  The preferred use of these functions is with a \code{\link{formula}}
  object. Specifically, a hierarchical formula argument is used to assign the
  levels of the strata. An example of a hierarchical formula would
  be:\tabular{r}{ \code{~Country/City/Neighborhood}} This convention was
  chosen as it becomes easier to type and makes intuitive sense when defining
  a \code{\link{hierarchy}}. Note: it is important to use hiearchical
  formulas when specifying hierarchies as other types of formulas (eg.
  \code{~Country*City*Neighborhood}) will give incorrect results.}
}
\examples{
# let's look at the microbov data set:
data(microbov)
microbov

# We see that we have three vectors of different names in the 'other' slot.
# ?microbov
# These are Country, Breed, and Species
names(other(microbov))

# Let's set the strata
strata(microbov) <- data.frame(other(microbov))
microbov

# And change the names so we know what they are
nameStrata(microbov) <- ~Country/Breed/Species

\dontrun{
# let's see what the strata looks like by Species and Breed:
head(strata(microbov, ~Breed/Species))

# If we didn't want the last column combined with the first, we can set
# combine = FALSE
head(strata(microbov, ~Breed/Species, combine = FALSE))

#### USING splitStrata ####

# For the sake of example, we'll imagine that we have imported our data set
# with all of the stratifications combined.
setPop(microbov) <- ~Country/Breed/Species
strata(microbov) <- NULL

# This is what our data would look like after import.
microbov

# To set our strata here, we need to use the functions strata and splitStrata
strata(microbov) <- data.frame(x = pop(microbov))
microbov # shows us that we have "one" level of stratification
head(strata(microbov)) # all strata are separated by "_"

splitStrata(microbov) <- ~Country/Breed/Species
microbov # Now we have all of our strata named and split
head(strata(microbov)) # all strata are appropriately named and split.
}
}
\author{
Zhian N. Kamvar
}
\seealso{
\code{\link{setPop}} \code{\link{genind}}
  \code{\link{as.genind}}
}

