% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.r
\name{radeba}
\alias{radeba}
\alias{dadeba}
\alias{padeba}
\title{ADEBA estimates}
\usage{
radeba(n, object)

dadeba(x, object)

padeba(q, object, lower.tail = TRUE)
}
\arguments{
\item{n}{Number of examples to sample.}

\item{object}{Density estimate.}

\item{x, q}{Vector of quantiles.}

\item{lower.tail}{Logical; If \code{TRUE} (default), probabilities are
\eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}
}
\description{
Density, distribution, and random generation for ADEBA estimates.
Works just like \code{\link{rnorm}}, \code{\link{runif}}, etc.
}
\examples{
data(faithful)
f <- adeba(faithful$eruptions, adaptive=FALSE)
f.eruptions <- radeba(1e5, f)
hist(f.eruptions, breaks=100, col="skyblue", probability=TRUE)
lines(f, lwd=3)
rug(faithful$eruptions)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
