% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_saved_trials.R
\name{update_saved_trials}
\alias{update_saved_trials}
\title{Update previously saved simulations}
\usage{
update_saved_trials(path, version = NULL, compress = TRUE)
}
\arguments{
\item{path}{single character; the path to the saved \code{"trial_results"}-object
containing the simulations saved by \code{\link[=run_trials]{run_trials()}}.}

\item{version}{passed to \code{\link[=saveRDS]{saveRDS()}} when saving the updated object, defaults
to \code{NULL} (as in \code{\link[=saveRDS]{saveRDS()}}), which means that the current default version
is used.}

\item{compress}{passed to \code{\link[=saveRDS]{saveRDS()}} when saving the updated object,
defaults to \code{TRUE} (as in \code{\link[=saveRDS]{saveRDS()}}), see \code{\link[=saveRDS]{saveRDS()}} for other options.}
}
\value{
Invisibly returns the updated \code{"trial_results"}-object.
}
\description{
This function updates a previously saved \code{"trial_results"}-object created and
saved by \code{\link[=run_trials]{run_trials()}} using a previous version of \code{adaptr}, allowing the
results from these previous simulations to be post-processed (including
performance metric calculation, printing and plotting) without errors by this
version of the package. The function should be run only once per saved
simulation object and will issue a warning if the object is already up to
date.\cr
\strong{NOTE:} some values cannot be updated and will be set to \code{NA} (the
posterior estimates from the 'final' analysis conducted after the last
adaptive analysis and including outcome data for all patients), and thus
using both \code{raw_ests = TRUE} and \code{final_ests = TRUE} in the
\code{\link[=extract_results]{extract_results()}} and \code{\link[=summary]{summary()}} functions will lead to missing values for
some of the values calculated for updated simulation objects.\cr
\strong{NOTE:} other objects created by the \code{adaptr} package, i.e., trial
specifications generated by
\code{\link[=setup_trial]{setup_trial()}}/\code{\link[=setup_trial_binom]{setup_trial_binom()}}/\code{\link[=setup_trial_norm]{setup_trial_norm()}} and single
simulation results from \code{\link[=run_trials]{run_trials()}} when not included in as part of the
returned output from \code{\link[=run_trials]{run_trials()}} should be re-created by re-running the
relevant code using the updated version of \code{adaptr}; if manually re-loaded
from previous sessions, they may cause errors and problems with the updated
version of the package.
}
\seealso{
\code{\link[=run_trials]{run_trials()}}.
}
