% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_status.R
\name{extract_statuses}
\alias{extract_statuses}
\title{Extract statuses}
\usage{
extract_statuses(object, x_value, arm = NULL)
}
\arguments{
\item{object}{\code{trial_results} object from \code{\link[=run_trials]{run_trials()}}.}

\item{x_value}{single character string, determining whether the number of
adaptive analysis looks (\code{"look"}, default), the total cumulated number of
patients randomised (\code{"total n"}) or with outcome data available at each
analysis (\code{"followed n"}) are plotted on the x-axis.}

\item{arm}{character string of one or more unique, valid \code{arm} names, \code{NA},
or \code{NULL} (default). If \code{NULL}, the overall trial statuses are plotted,
otherwise the specified arms or all arms (if \code{NA} is specified) are plotted.}
}
\value{
A tidy \code{data.frame} (one row possible status per look) containing the
following columns:
\itemize{
\item \code{x}: the look numbers or total number of patients at each look,
as specified in \code{x_value}.
\item \code{status}: each possible status (\code{"Recruiting"}, \code{"Inferiority"}
(only relevant for individual arms), \code{"Futility"}, \code{"Equivalence"}, and
\code{"Superiority"}, as relevant).
\item \code{p}: the proportion (\code{0-1}) of patients with each \code{status} at each
value of \code{x}.
\item \code{value}: as described under \code{metric}.
}
}
\description{
Used internally. Extracts overall trial statuses or statuses from a single
\code{arm} from multiple trial simulations. Works with \emph{sparse} results.
}
\keyword{internal}
