% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prms.R
\name{prms}
\alias{prms}
\title{Compute the passing rate for the mixed scaling approach in bioequivalence (BE) studies}
\usage{
prms(n, r, params = list(), nsim = 1000, ncores = NULL)
}
\arguments{
\item{n}{The number of donors in each simulation.}

\item{r}{The number of replicates from each donor for each simulated dataset.}

\item{params}{(Optional) The list of true parameters to be assumed in data generation.
\itemize{
\item \code{sigma_W0} - A regulatory constant set by the FDA. Defaults to 0.25.
\item \code{sigma_WT} - The true standard deviation of the test formulation population.
\item \code{sigma_WR} - The true standard deviation of the reference formulation population.
\item \code{GMR} - The geometric mean ratio of the test and reference values of the pharmacokinetic measures (e.g., Jmax or AUC). If the test-formulation measure is greater than that of the reference formulation, then GMR is typically set to 1.05, which is the initial value of this function. If the reference-formulation measure is bigger, then GMR is typically 0.95. Defaults to 0.95.
\item \code{m} - Another regulatory constant that determines the bounds within which the estimated GMR should fall for bioequivalence to be established. Defaults to 1.25, representing 80-125\% average BE limits, which is the FDA recommendation.
\item \code{sig_level} - The significance level (alpha-level). Defaults to 0.05.
}}

\item{nsim}{(Optional) The number of total simulations to be conducted. Defaults to 1,000.}

\item{ncores}{(Optional) The number of CPU cores to use for parallel processing (OpenMP). If R hasn't been installed with OpenMP configured, this will not take effect. When OpenMP is available, it should not exceed the number of existing cores. If unspecified, it will default to 2 cores or the number of existing cores, whichever is smaller.}
}
\value{
A list of lists
\itemize{
\item \code{parameters} - A list of true parameter settings.
\item \code{passing_rate} - The estimated passing rate.
\item \code{runtime} - The total elapsed time charged for the execution of the program.
}
}
\description{
This function runs Monte Carlo simulations to compute the passing rate (PR) of the mixed scaling (MS) approach.
}
\examples{
out <- prms(10, 6, nsim = 2)

}
\references{
Davit, B. M., Chen, M. L., Conner, D. P., Haidar, S. H., Kim, S., Lee, C. H., Lionberger, R. A., Makhlouf, F. T., Nwakama, P. E., Patel, D. T., Schuirmann, D. J., & Yu, L. X. (2012). Implementation of a reference-scaled average bioequivalence approach for highly variable generic drug products by the US Food and Drug Administration. The AAPS journal, 14(4), 915-924.
}
\author{
Daeyoung Lim, \email{daeyoung.lim@uconn.edu}
}
