% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity_code.r
\name{redf}
\alias{redf}
\title{Random numbers from empirical distribution function.}
\usage{
redf(n, fit)
}
\arguments{
\item{n}{Integer number of random numbers to return.}

\item{fit}{Data frame defining the emprical distribution (see details).}
}
\value{
A numeric vector.
}
\description{
Random numbers drawn from an empirical distribution defined by paired values and probabilities.
}
\details{
The distribution function is defined by \code{fit}, which must be a dataframe containing (at least) columns named:
 x: a regular sequence of values from which to draw;
 y: corresponding pdf values.
}
\examples{
data(BCItime)
tm <- 2*pi*subset(BCItime, species=="paca")$time
mod <- fitact(tm)
rn <- redf(1000, as.data.frame(mod@pdf))
}
