% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotResidency}
\alias{plotResidency}
\title{Plot residency for a single tag}
\usage{
plotResidency(input, tag, title, xlab, ylab, col)
}
\arguments{
\item{input}{The results of an actel analysis (either explore, migration or residency).}

\item{tag}{The transmitter to be plotted.}

\item{title}{An optional title for the plot. If left empty, a default title will be added.}

\item{xlab, ylab}{Optional axis names for the plot. If left empty, default axis names will be added.}

\item{col}{An optional colour scheme for the detections. If left empty, default colours will be added.}
}
\value{
A ggplot object.
}
\description{
The output of plotResidency is a ggplot object, which means you can then use it in combination
with other ggplot functions, or even together with other packages such as patchwork.
}
\examples{
# For this example, I have modified the example.results that come with actel,
# so they resemble a residency output
\dontshow{
example.residency.results <- c(example.results, additional.residency.results)
example.residency.results$rsp.info$analysis.type <- "residency"
}
plotResidency(example.residency.results, 'R64K-4451')

# Because plotResidency returns a ggplot object, you can store
# it and edit it manually, e.g.:
library(ggplot2)
p <- plotResidency(example.residency.results, 'R64K-4451')
p <- p + xlab("changed the x axis label a posteriori")
p

# You can also save the plot using ggsave!

}
