% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations_delete.R
\name{annotations_delete}
\alias{annotations_delete}
\title{Delete annotations}
\usage{
annotations_delete(
  x,
  pattern = "",
  filterTranscriptNames = NULL,
  filterTierNames = NULL
)
}
\arguments{
\item{x}{Corpus object.}

\item{pattern}{Character string; regular expression; all annotations that match this expression will be deleted.}

\item{filterTranscriptNames}{Vector of character strings; names of the transcripts to be included.}

\item{filterTierNames}{Character string; names of the tiers to be included.}
}
\value{
Corpus object.
}
\description{
Delete annotations in a corpus object.
If only certain transcripts or tiers should be affected set the parameter \code{filterTranscriptNames} and \code{filterTierNames}.
In case that you want to select transcripts and/or tiers by using regular expressions use the function \code{act::search_makefilter} first.
}
\examples{
library(act)

# Set the regular expression which annotations should be deleted.
# In this case: all annotations that contain the letter "a"
myRegEx <- "a"

# Have a look at all annotations in the first transcript
examplecorpus@transcripts[[1]]@annotations$content

# Some of them match to the regular expression
hits <- grep(pattern=myRegEx, x=examplecorpus@transcripts[[1]]@annotations$content)
examplecorpus@transcripts[[1]]@annotations$content[hits]
# Others don't match the regular expression
examplecorpus@transcripts[[1]]@annotations$content[-hits]

# Run the function and delete the annotations that match the regular expression
test <- act::annotations_delete (x=examplecorpus, pattern=myRegEx)

# Compare how many data rows are in the first transcript in 
# the example corpus and in the newly created test corpus:
nrow(examplecorpus@transcripts[[1]]@annotations)
nrow(test@transcripts[[1]]@annotations)

# Only the annotations are left, that did not match the regular expression:
test@transcripts[[1]]@annotations$content
}
