% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_openresult_inpraat.R
\name{search_openresult_inpraat}
\alias{search_openresult_inpraat}
\title{Open a search result in 'Praat'}
\usage{
search_openresult_inpraat(
  x,
  s,
  resultNr,
  play = TRUE,
  closeAfterPlaying = FALSE,
  filterMediaFile = c(".*\\\\.(aiff|aif|wav)", ".*\\\\.mp3")
)
}
\arguments{
\item{x}{Corpus object.}

\item{s}{Search object.}

\item{resultNr}{Integer; Number of the search result (row in the data frame \code{s@results}) to be played.}

\item{play}{Logical; If \code{TRUE} selection will be played.}

\item{closeAfterPlaying}{Logical; If \code{TRUE} TextGrid editor will be closed after playing (Currently non functional!)}

\item{filterMediaFile}{Vector of character strings; Each element of the vector is a regular expression. Expressions will be checked consecutively. The first match with an existing media file will be used for playing. The default checking order is uncompressed audio > compressed audio.}
}
\description{
The function remote controls 'Praat' by using 'sendpraat' and a 'Praat' script. 
It opens a search result in the 'Praat' TextGrid Editor.
}
\details{
To make this function work you need to set the path to the 'sendpraat' executable using 'options(act.path.sendpraat = ...)'.
}
\examples{
library(act)

mysearch <- act::search_new(x=examplecorpus, pattern = "pero")

# You can only use this functions if you have located the 'sendpraat' 
# executable properly in the package options.
\dontrun{
act::search_openresult_inpraat(x=examplecorpus, s=mysearch, resultNr=1, TRUE, TRUE)
}
}
