% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tiers_sort.R
\name{tiers_sort}
\alias{tiers_sort}
\title{Reorder tiers in all transcripts of a corpus}
\usage{
tiers_sort(
  x,
  sortVector,
  filterTranscriptNames = NULL,
  addMissingTiers = FALSE,
  deleteTiersThatAreNotInTheSortVector = FALSE
)
}
\arguments{
\item{x}{Corpus object.}

\item{sortVector}{Vector of character strings; regular expressions to match the tier names. The order within the vector presents the new order of the tiers. Use "\\*" (=two backslashes and a star) to indicate where tiers that are not present in the sort vector but in the transcript should be inserted.}

\item{filterTranscriptNames}{Vector of character strings; names of the transcripts to be included.}

\item{addMissingTiers}{Logical; if \code{TRUE} all tiers that are given in 'the 'sortVector' but are missing in the transcripts will be added.}

\item{deleteTiersThatAreNotInTheSortVector}{Logical; if \code{TRUE} tiers that are not matched by the regular expressions in 'sortVector' will be deleted. Otherwise the will be inserted at the end of the table or at the position defined by '"\\*' in  'sortVector.}
}
\value{
Corpus object.
}
\description{
Reorder the positions of tiers in all transcripts of a corpus object. 
The ordering of the tiers will be done according to a vector of regular expressions defined in 'sortVector'.
If only certain transcripts or tiers should be affected set the parameter \code{filterTranscriptNames}.
In case that you want to select transcripts by using regular expressions use the function \code{act::search_meta} first.
}
\examples{
library(act)

# Check the order of the existing tiers in the first two transcripts
examplecorpus@transcripts[[1]]@tiers$name[order(examplecorpus@transcripts[[1]]@tiers$position)]
examplecorpus@transcripts[[2]]@tiers$name[order(examplecorpus@transcripts[[2]]@tiers$position)]

# Get tier names to create the sort vector
sortVector <- c(examplecorpus@transcripts[[1]]@tiers$name,
                examplecorpus@transcripts[[2]]@tiers$name)

# Revert the vector for demonstration.
sortVector <- sortVector[length(sortVector):1]

# This will only reorder the tiers.
examplecorpus <- act::tiers_sort(x=examplecorpus, 
sortVector=sortVector)

# Check again the order of the tiers
examplecorpus@transcripts[[1]]@tiers$name[order(examplecorpus@transcripts[[1]]@tiers$position)]
examplecorpus@transcripts[[2]]@tiers$name[order(examplecorpus@transcripts[[2]]@tiers$position)]

# This will reorder the tiers and additionally add tiers that are given  
# in the sort vector but not present in the transcript.
examplecorpus <- act::tiers_sort(x=examplecorpus,
sortVector=sortVector,
addMissingTiers=TRUE)
# Check again the order of the tiers
examplecorpus@transcripts[[1]]@tiers$name[order(examplecorpus@transcripts[[1]]@tiers$position)]
examplecorpus@transcripts[[2]]@tiers$name[order(examplecorpus@transcripts[[2]]@tiers$position)]

# Insert a tier called "newTier" into all transcripts in the corpus:
for (t in examplecorpus@transcripts) {
 sortVector <- c(t@tiers$name, "newTier")
 examplecorpus <- act::tiers_sort(x=examplecorpus,
sortVector=sortVector,
filterTranscriptNames=t@name,
addMissingTiers=TRUE)
}
# Check for example the first transcript: it now contains a tier called "newTier"
examplecorpus@transcripts[[1]]@tiers


# To get more examples and information about sorting see 'helper_tiers_sort_table()'.
}
\seealso{
\link{tiers_convert}, \link{tiers_rename}, \link{helper_tiers_new_table}, \link{helper_tiers_sort_table},
}
