% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_sub.R
\name{search_sub}
\alias{search_sub}
\title{Add a sub search to a prior search}
\usage{
search_sub(
  x,
  s,
  pattern,
  filterTierInclude = "",
  filterTierExclude = "",
  destinationColumn = "subsearch",
  deleteLinesWithNoResults = FALSE,
  excludeHitsWithinSameTier = TRUE
)
}
\arguments{
\item{x}{Corpus object.}

\item{s}{Search object.}

\item{pattern}{Character string; search pattern as regular expression}

\item{filterTierInclude}{Character string; limit search to tiers that match the regular expression}

\item{filterTierExclude}{Character string; limit search to tiers that match the regular expression}

\item{destinationColumn}{Character string; name of column where results of sub search will be stored}

\item{deleteLinesWithNoResults}{Logical; if \code{TRUE} search results will be deleted for which the sub search does not give any results}

\item{excludeHitsWithinSameTier}{Logical; if \code{TRUE} the function will not add hits from the same tier as the original search result; if \code{FALSE} hits from the same tier as the original search result will be included.}
}
\value{
Data frame.
}
\description{
This function starts from the results of a prior search and performs a sub search. 
In the sub search all results from the prior search will be checked. 
The sub search will check annotations in other tiers that temporally overlap with the original search result. 
Those annotation will be checked if they match a search pattern.
If so, the search hit of the sub search will be added to a new column in the original search results data frame.
}
\examples{
library(act)

# Lets search for instances where participants laugh together
# First search for annotations that contain laughter (in original content)
myRegEx <- "(\\\\brie\\\\b|\\\\briendo\\\\b)"
mysearch <- act::search_new(x=examplecorpus,
							pattern=myRegEx,
							searchNormalized = FALSE)
mysearch@results.nr

# Now perform sub search, also on laughs/laughing
test <- act::search_sub(x=examplecorpus,
						s=mysearch,
						pattern=myRegEx)

# Check the co-occurring search hits
test$subsearch
}
\seealso{
\link{search_new}, \link{search_run}, \link{search_meta}
}
