% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_tiers_rename.R
\name{modify_tiers_rename}
\alias{modify_tiers_rename}
\title{Rename tiers}
\usage{
modify_tiers_rename(x, pattern, replacement, filterTranscriptsInclude = "")
}
\arguments{
\item{x}{Corpus object.}

\item{pattern}{Character string; search pattern as regular expression.}

\item{replacement}{Character string; replacement string.}

\item{filterTranscriptsInclude}{Character string; only transcripts that match the regular expression will be affected.}
}
\value{
Corpus object.
}
\description{
Renames all tiers in all transcript objects of a corpus.
The tiers will only be renamed if the resulting names preserve the uniqueness of the tier names.
Results  will be reported in \code{@lastModification} of the corpus object.
Please be aware that this function is not optimized for speed and may take quite a while to run, depending on the size of your corpus object.
}
\examples{
library(act)

# Check the names of the existing tiers in the first two transcripts
names(examplecorpus@transcripts[[1]]@tiers)
names(examplecorpus@transcripts[[2]]@tiers)

examplecorpus <- act::modify_tiers_rename(examplecorpus, "Entrevistador", "E")

names(examplecorpus@transcripts[[1]]@tiers)
names(examplecorpus@transcripts[[2]]@tiers)

}
