% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_save.R
\name{matrix_save}
\alias{matrix_save}
\title{Save replacement matrix}
\usage{
matrix_save(replacementMatrix, path, myFileEncoding = "UTF-8")
}
\arguments{
\item{replacementMatrix}{Data.frame; replacement matrix.}

\item{path}{Character string; path where the matrix will be saved.}

\item{myFileEncoding}{Character string; encoding of the file.}
}
\value{
nothing
}
\description{
Save replacement matrix
}
\examples{
library(act)

# An example replacement matrix comes with the package.
path <- system.file("extdata", "normalization", "normalizationMatrix.csv", package="act")

# Load the matrix
mymatrix <- act::matrix_load(path)

#' #Create temporary file path
path <- tempfile(pattern = "mymatrix", tmpdir=tempdir(),  fileext = ".csv")

# It makes more sense, however, to you define a destination folder
# that is easier to access on your computer:
\dontrun{
path <- file.path("PATH_TO_AN_EXISTING_FOLDER_ON_YOUR_COMPUTER",
                  "mymatrix.csv")
}

# Save the matrix
act::matrix_save(mymatrix, path=path)

}
