% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{frac_complete}
\alias{frac_complete}
\title{Demand minimal fraction of complete records}
\usage{
frac_complete(r, vars = TRUE)
}
\arguments{
\item{r}{Minimal fraction of records that must be complete.}

\item{vars}{\code{[TRUE|column index]} Column index into the data to
be tested (e.g. a character vectod with variable names or
a numeric vector with column positions). The indexed columns
will be testsed for completeness (absence of \code{NA}). Be default
\code{vars=TRUE} meaning that all columns are taken into account.}
}
\value{
a function that accepts a data frame and returns \code{TRUE} when the
        fraction of complete records is larger than or equal to \code{n} and
        otherwise \code{FALSE}.
}
\description{
Demand minimal fraction of complete records
}
\examples{

f <- frac_complete(0.1)
f(mtcars) # TRUE (all complete)
mt <- mtcars
mt[1:5,1] <- NA
f(mt)     # FALSE (5/32 incomplete)

}
\seealso{
Other helpers: 
\code{\link{min_complete}()},
\code{\link{min_records}()}
}
\concept{helpers}
