% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gini_index.R
\name{gini_index}
\alias{gini_index}
\title{Gini index}
\usage{
gini_index(
  accessibility_data,
  sociodemographic_data,
  opportunity,
  population,
  group_by = character(0)
)
}
\arguments{
\item{accessibility_data}{A data frame. The accessibility levels whose
inequality should be calculated. Must contain the columns \code{id} and any
others specified in \code{opportunity}.}

\item{sociodemographic_data}{A data frame. The distribution of
sociodemographic characteristics of the population in the study area cells.
Must contain the columns \code{id} and any others specified in \code{population}.}

\item{opportunity}{A string. The name of the column in \code{accessibility_data}
with the accessibility levels to be considerend when calculating inequality
levels.}

\item{population}{A string. The name of the column in \code{sociodemographic_data}
with the number of people in each cell. Used to weigh accessibility levels
when calculating inequality.}

\item{group_by}{A \code{character} vector. When not \code{character(0)} (the default),
indicates the \code{accessibility_data} columns that should be used to group the
inequality estimates by. For example, if \code{accessibility_data} includes a
\code{departure_time} column that specifies the departure time that each entry
refers to, passing \code{"departure_time"} to this parameter results in
inequality estimates grouped by departure time.}
}
\value{
A data frame containing the inequality estimates for the study area.
}
\description{
Calculates the Gini index of a given accessibility distribution.
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data_dir <- system.file("extdata", package = "accessibility")
travel_matrix <- readRDS(file.path(data_dir, "travel_matrix.rds"))
land_use_data <- readRDS(file.path(data_dir, "land_use_data.rds"))

access <- cumulative_cutoff(
  travel_matrix,
  land_use_data,
  cutoff = 30,
  opportunity = "jobs",
  travel_cost = "travel_time"
)

gini <- gini_index(
  access,
  sociodemographic_data = land_use_data,
  opportunity = "jobs",
  population = "population"
)
gini
\dontshow{\}) # examplesIf}
}
\seealso{
Other inequality: 
\code{\link{palma_ratio}()}
}
\concept{inequality}
