% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decay_binary.R
\name{decay_binary}
\alias{decay_binary}
\title{Binary (a.k.a. step) decay function}
\usage{
decay_binary(cutoff)
}
\arguments{
\item{cutoff}{A \code{numeric}. A number indicating the travel cost cutoff.}
}
\value{
A \code{function} that takes a generic travel cost vector (\code{numeric}) as
an input and returns a vector of weights (\code{numeric}).
}
\description{
Returns a binary weighting function (frequently used to calculate cumulative
opportunities measures) to be used inside accessibility calculating
functions.

This function is generic over any kind of numeric travel cost,
such as distance, time and money.
}
\examples{
weighting_function <- decay_binary(cutoff = 30)

weighting_function(20)

weighting_function(35)

}
\seealso{
Other decay functions: 
\code{\link{decay_exponential}()},
\code{\link{decay_linear}()},
\code{\link{decay_power}()},
\code{\link{decay_stepped}()}
}
\concept{decay functions}
