% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingFunctions.R
\name{ASDABarPlot}
\alias{ASDABarPlot}
\title{barplot for ASDA objects}
\usage{
ASDABarPlot(asdaObj, numDVs = 1, xlabel, ylabel, getList = FALSE, main, ...)
}
\arguments{
\item{asdaObj}{Object from the \code{ASDA} function.}

\item{numDVs}{Number of discriminant vectors (DVs) to plot. This is limited by the
number of DVs outputted from the \code{ASDA} function or k-1 DVs where k
is the number of classes. The first 1 to numDVs are plotted.}

\item{xlabel}{Label to put under every plot}

\item{ylabel}{Vector of y-axis labels for each plot, e.g. if there are three DVs, then
\code{ylab = c('Discriminant Vector 1', 'Discriminant Vector 2', 'Discriminant Vector 3')}
is a valid option.}

\item{getList}{Logical value indicating whether the output should be a list of the plots
or the plots stacked in one plot using the gridExtra package. By default the function
produces a single plot combining all plots of the DVs.}

\item{main}{Main title for the plots, this is not used if getList is set to \code{TRUE}.}

\item{...}{Extra arguments to \code{grid.arrange}.}
}
\value{
\code{barplot.ASDA} returns either a single combined plot or a list of
        individual ggplot objects.
}
\description{
This is a function to visualize the discriminant vector from the ASDA
    method. The plot is constructed as a ggplot barplot and the main purpose of it is
    to visually inspect the sparsity of the discriminant vectors. The main things to
    look for are how many parameters are non-zero and if there is any structure in
    the ones that are non-zero, but the structure is dependent on the order you specify
    your variables. For time-series data, this could mean that a chunk of variables are
    non-zero that are close in time, meaning that there is some particular event that is
    best for discriminating between the classes that you have.
}
\note{
This function is used as a quick diagnostics tool for the output from the ASDA function.
      Feel free to look at the code to customize the plots in any way you like.
}
\examples{
    # Generate and ASDA object with your data, e.g.
    # Prepare training and test set
    # This is a very small data set, I advise you to try it on something with more
    # variables, e.g. something from this source: http://www.cs.ucr.edu/~eamonn/time_series_data/
    # or possibly run this on the Gaussian data example from the ASDA function
    train <- c(1:40,51:90,101:140)
    Xtrain <- iris[train,1:4]
    nX <- normalize(Xtrain)
    Xtrain <- nX$Xc
    Ytrain <- iris[train,5]
    Xtest <- iris[-train,1:4]
    Xtest <- normalizetest(Xtest,nX)
    Ytest <- iris[-train,5]
    # Run the method
    resIris <- ASDA(Xtrain,Ytrain)

    # Look at the barplots of the DVs
    ASDABarPlot(resIris)
}
\seealso{
\code{\link{ASDA}}
}
