% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{extract_parameters_mixed_effects}
\alias{extract_parameters_mixed_effects}
\title{Helper function to extract parameters for mixed-effects models}
\usage{
extract_parameters_mixed_effects(
  mu,
  betas,
  sigma,
  sigma_alpha,
  distribution,
  node_id,
  parent_nodes,
  start_counter,
  link_function
)
}
\arguments{
\item{mu}{Fixed-effect intercept(s) from mu component}

\item{betas}{Fixed-effect coefficients from betas component}

\item{sigma}{Residual variance from sigma component}

\item{sigma_alpha}{Random-effect variance/covariance from sigma_alpha component}

\item{distribution}{Node distribution type}

\item{node_id}{Node identifier}

\item{parent_nodes}{Parent node identifiers}

\item{start_counter}{Starting parameter counter}

\item{link_function}{Link function name}
}
\description{
Helper function to extract parameters for mixed-effects models
}
\details{
Extracts parameters from mixed-effects models following the new JSON structure.

For each node, creates parameters for:
\itemize{
\item Fixed-effect intercept (from mu)
\item Fixed-effect coefficients for parents (from betas)
\item Residual variance (from sigma, for Gaussian/Poisson)
\item Random-effect variance/covariance (from sigma_alpha)
}
}
\keyword{internal}
