% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{ablasso_uv_ss}
\alias{ablasso_uv_ss}
\title{AB-LASSO Estimator with Random Sample Splitting}
\usage{
ablasso_uv_ss(Y, D, nboot = 100, Kf = 2, seed = 202304)
}
\arguments{
\item{Y}{A \code{P} x \code{N} (number of time periods x number of individuals) matrix containing the outcome/response variable variable \code{Y}.}

\item{D}{A \code{P} x \code{N} (number of time periods x number of individuals) matrix containing the policy variable/treatment \code{D}.}

\item{nboot}{The number of random sample splits, default is \code{100}.}

\item{Kf}{The number of folds for K-fold cross-validation, with options being \code{2} or \code{5}, default is \code{2}.}

\item{seed}{Seed for random number generation, default \code{202304}.}
}
\value{
A list with three elements:
\itemize{
\item theta.hat: Estimated coefficients.
\item std.hat: Estimated Standard errors.
\item stat: T-Statistics.
}
}
\description{
Implements the AB-LASSO estimation method for the univariate model \eqn{Y_{it} = \alpha_{i} + \gamma_{t} + \theta_{1} Y_{i,t-1} + \theta_{2} D_{it} + \varepsilon_{it}}, incorporating random sample splitting. Note that \eqn{D_{it}} is predetermined with respect to \eqn{\varepsilon_{it}}.
}
\examples{
\donttest{
# Generate data
data1 <- generate_data(N = 300, P = 40)

# You can use your own data by providing matrices `Y` and `D`
results.ss <- ablasso_uv_ss(Y = data1$Y, D = data1$D, nboot = 2)
print(results.ss)

results.ss2 <- ablasso_uv_ss(Y = data1$Y, D = data1$D, nboot = 2, Kf = 5)
print(results.ss2)
}
}
