% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abclass_propscore.R
\name{abclass_propscore}
\alias{abclass_propscore}
\title{Estimate Propensity Score by the Angle-Based Classifiers}
\usage{
abclass_propscore(
  x,
  treatment,
  loss = c("logistic", "boost", "hinge.boost", "lum"),
  penalty = c("glasso", "gscad", "gmcp", "lasso", "scad", "mcp", "cmcp", "gel",
    "mellowmax", "mellowmcp"),
  weights = NULL,
  offset = NULL,
  intercept = TRUE,
  control = list(),
  tuning = c("et", "cv_1se", "cv_min"),
  ...
)
}
\arguments{
\item{x}{A numeric matrix representing the design matrix.  No missing valus
are allowed.  The coefficient estimates for constant columns will be
zero.  Thus, one should set the argument \code{intercept} to \code{TRUE}
to include an intercept term instead of adding an all-one column to
\code{x}.}

\item{treatment}{The assigned treatments represented by a character,
integer, numeric, or factor vector.}

\item{loss}{A character value specifying the loss function.  The available
options are \code{"logistic"} for the logistic deviance loss,
\code{"boost"} for the exponential loss approximating Boosting machines,
\code{"hinge.boost"} for hybrid of SVM and AdaBoost machine, and
\code{"lum"} for largin-margin unified machines (LUM).  See Liu, et
al. (2011) for details.}

\item{penalty}{A character vector specifying the name of the penalty.}

\item{weights}{A numeric vector for nonnegative observation weights. Equal
observation weights are used by default.}

\item{offset}{An optional numeric matrix for offsets of the decision
functions.}

\item{intercept}{A logical value indicating if an intercept should be
considered in the model.  The default value is \code{TRUE} and the
intercept is excluded from regularization.}

\item{control}{A list of control parameters. See \code{abclass.control()}
for details.}

\item{tuning}{A character vector specifying the tuning method.  This
argument will be ignored if a single \code{lambda} is specified through
\code{control}.}

\item{...}{Other arguments passed to the corresponding methods.}
}
\description{
A wrap function to estimate the propensity score by the multi-category
angle-based large-margin classifiers.
}
