% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{simu_failTime}
\alias{simu_failTime}
\title{Simulate samples of failure time using parameters \eqn{\theta}}
\usage{
simu_failTime(paras, n, tau_c, t_c, verbose = FALSE)
}
\arguments{
\item{paras}{either a vector or a matrix where each row is \eqn{\theta}}

\item{n}{number of samples}

\item{tau_c}{constant load level (can be set to infinity for ramp load test)}

\item{t_c}{ending time of the constant load test in hours (can be set to infinity for ramp load test)}

\item{verbose}{print information messages to console if TRUE}
}
\value{
Return a matrix of failure times. Each column contains samples from one \eqn{\theta}.
The name of the output matrix must be in the format "ID_\eqn{\tau_c}_t_c(in years)", e.g. simuConstLoad_4500_1Y.
}
\description{
Simulate n observations of failure time from
 \eqn{\theta = (\mu_a, \sigma_a, \mu_b, \sigma_b, \mu_c, \sigma_c, \mu_n, \sigma_n, \mu_{\sigma_0} , \sigma_{\sigma_0})}{\theta = (\mu_a, \sigma_a, \mu_b, \sigma_b, \mu_c, \sigma_c, \mu_n, \sigma_n, \mu_\sigma0 , \sigma_\sigma0)}
 for constant load test or ramp load test.
}
\details{
* The default \eqn{\theta} is provided and can be invoked via \code{\link{default_param}}.

* When sample pieces are subject to the load profile

\eqn{\tau(t) = kt} if \eqn{t \le T_0}{t <= T_0}

\eqn{\tau(t) = \tau_c} if \eqn{t > T_0}

where \eqn{\tau_c} is the selected constant-load level under the ramp-loading rate k, and \eqn{T_0} is the
time required for the load to reach \eqn{\tau_c} under the ramp-loading rate k.

* The constant load level is assumed to be reached at the ramp-loading rate (k). The ramp-loading rate is 388,440 psi/hour.

Utilizes routines from the BRENT C++ root-finding library.
}
\examples{
# simulate data with constant load 4500 psi and test of duration 1Y (8760 hours)
simuConstLoad_4500_1Y = simu_failTime(default_param, 30, 4500, 8760, TRUE)

# simulate data for ramp load
simuRampLoad_Inf_1Y = simu_failTime(default_param, 30, Inf, 8760)


}
\references{
Brent, R. (2002). Algorithms for Minimization without Derivatives. Dover. ISBN: 0-486-41998-3.

Yang, C. H., Zidek, J. V., & Wong, S. W. (2019). Bayesian analysis of accumulated damage models in lumber reliability. Technometrics, 61(2), 233-245.
}
