% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_lme.R
\name{stat_lme}
\alias{stat_lme}
\title{Create an lme stat object.}
\usage{
stat_lme(id, time, std.beta = FALSE, complete.cases = TRUE)
}
\arguments{
\item{id}{string. This is the variable in the data which represents the
subject id to be used for random intercepts and random slopes.}

\item{time}{string. This is the time variable in the data which represents
the time from baseline that the visit occured.}

\item{std.beta}{logical. Whether to standardize model predictors and
covariates prior to analysis.}

\item{complete.cases}{logical. Whether to only include the subset of data
with no missing data for any of the outcomes, predictors, or covariates.
Note that complete cases are considering within each group - outcome
combination but across all predictor sets.}
}
\value{
An abaStat object with \code{lme} stat type.
}
\description{
This function creates an lme stat object which can be passed as input
to the \code{set_stats()} function when building an aba model. This stat performs
a linear mixed effects model analysis using the \code{lme} function from the
\code{nlme} package. Please note that the default mode is to include an interaction
term between the \code{time} variable and each predictor - i.e., \code{time*predictor}
will be in the model formula - but this does not happen for covariates. Also,
this model fits random intercepts and random slopes. The data for this model
should be in long format with one row per subject-visit.
}
\examples{

data <- adnimerge \%>\%
  dplyr::filter(VISCODE \%in\% c('bl','m06','m12','m24'))

model <- data \%>\% aba_model() \%>\%
  set_groups(
    everyone(),
    DX_bl \%in\% c('MCI', 'AD')
  ) \%>\%
  set_outcomes(CDRSB, ADAS13) \%>\%
  set_predictors(
    PLASMA_ABETA_bl,
    PLASMA_PTAU181_bl,
    PLASMA_NFL_bl,
    c(PLASMA_ABETA_bl, PLASMA_PTAU181_bl, PLASMA_NFL_bl)
  ) \%>\%
  set_covariates(AGE, GENDER, EDUCATION) \%>\%
  set_stats(
    stat_lme(id = 'RID', time = 'YEARS_bl')
  ) \%>\%
  fit()

model_summary <- model \%>\% aba_summary()

}
