% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPropCorr.R
\name{getPropCorr}
\alias{getPropCorr}
\title{Get amino acid property wise correlations of co-evolving columns of a multiple sequence alignment}
\usage{
getPropCorr(selMat, propertyDF = "Cruciani", propertyIndex = 1)
}
\arguments{
\item{selMat}{A subset matrix of original multiple sequence alignment with significant correlations identified with 'getCorSites' function}

\item{propertyDF}{One of the amino acid property data frames. viz. Cruciani, Fasgai, Kidera, AAindex. Default is Cruciani properties}

\item{propertyIndex}{Specific property row number from the data frame of propertyDF}
}
\value{
A data frame of four columns viz. Pos1, Pos2, Cor and p Value. Results are filtered to find position pairs with correlations above 0.8 and below -0.8
}
\description{
Get amino acid property wise correlations of co-evolving columns of a multiple sequence alignment
}
\examples{
selMatLoc <- system.file("extdata", "selMat.rda", package = "aaSEA")
selMat <- readRDS(selMatLoc)
getPropCorr(selMat = selMat, propertyDF = "Cruciani", propertyIndex = 1) 
}
