% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTopSub.R
\name{getTopSub}
\alias{getTopSub}
\title{Get sites with more than one-correlated substitutions other than conserved amino acids at that position}
\usage{
getTopSub(selMat)
}
\arguments{
\item{selMat}{A subset matrix of original multiple sequence alignment with significant correlations identified with 'getCorSites' function}
}
\value{
A data frame with two columns i.e. Pos1 and Pos2 which is a filtered subset of many correlated substitutions based on frequency of substitution after consensus of a column in multiple sequence alignment
}
\description{
Get sites with more than one-correlated substitutions other than conserved amino acids at that position
}
\examples{
selMatLoc <- system.file("extdata", "selMat.rda", package = "aaSEA")
selMat <- readRDS(selMatLoc)
getTopSub(selMat = selMat)
}
