% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_mesh.R
\name{canvas_mesh}
\alias{canvas_mesh}
\title{Draw Meshes}
\usage{
canvas_mesh(colors, background = "#fafafa",
             transform = c("perlin", "fbm", "simplex", "cubic",
                           "worley", "knn", "rf", "svm"),
             lines = 500, iterations = 500, mixprob = 0)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{background}{a character specifying the color used for the background (and the hole).}

\item{transform}{a character specifying the type of transformation to use for the radius.}

\item{lines}{an integer specifying the number of lines to darw.}

\item{iterations}{a positive integer specifying the number of iterations of the algorithm.}

\item{mixprob}{a value between 0 and 1 specifying the probability of a line segment getting another color.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws one or more rotating circular morphing meshes on the canvas.
}
\examples{
\donttest{
set.seed(2)

# Simple example
canvas_mesh(colors = colorPalette("origami"))
}

}
\references{
\url{http://rectangleworld.com/blog/archives/462}
}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
