% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Compute_A0.R
\docType{methods}
\name{Compute_A0}
\alias{Compute_A0}
\alias{Compute_A0,aRchi-method}
\title{Find the principal axis of a tree}
\usage{
Compute_A0(aRchi, plotresult = FALSE)

\S4method{Compute_A0}{aRchi}(aRchi, plotresult = FALSE)
}
\arguments{
\item{aRchi}{an object of class aRchi with at least a QSM and the Paths table}

\item{plotresult}{logical (default = FALSE). Show the results in a 3d plot if TRUE}
}
\value{
The aRchi object with the QSM having a new column A0.
}
\description{
Find the principal axis of a tree (i.e A0) and add a column to the QSM of an aRchi object. This is alternative method to the default branch order proposed in a QSM for the principal axis only.
}
\details{
The method used to find the principal axis consist in finding the highest vertical path with consecutive segments of similar diameters and orientations. An index called A0 of the probability of being the principal axis is thus computed for each path of the tree and the path with the highest value is considered as the principal axis (see Martin-Ducup et al. 2020 for more information).

A0 ranges between 0 and 4 with 0 indicating a path with a low probability of being the principal axis and 4 indicating a high probability of being the principal axis, i.e. the highest vertical path with consecutive segments of similar diameters and orientations.The path with the maximum A0 value was selected as the principal axis.

The new column A0 of the QSM slot take the value 2 if the cylinder is part of the principal axis or 1 if not.
}
\examples{
\donttest{
# Read an aRchi file with at least the QSM and the paths table
file=system.file("extdata","Tree_1_aRchi.aRchi",package = "aRchi")
Tree1_aRchi=read_aRchi(file)

Tree1_aRchi=Compute_A0(Tree1_aRchi,plotresult=TRUE)
}
}
\references{
Martin-Ducup, O. et al. Terrestrial laser scanning reveals convergence of tree architecture with increasingly dominant crown canopy position. Functional Ecology (2020).
}
\seealso{
\code{\link{DAI}} to compute the dominance of a principal axis index that uses the A0 index.
}
