% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Juggler.Largest.R
\name{Juggler.Largest}
\alias{Juggler.Largest}
\alias{A094716}
\title{Largest value for Juggler sequence}
\usage{
Juggler.Largest(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A094716}{A094716}, the \emph{Largest value for Juggler sequence} is the largest value in trajectory of
a sequence that starts from \code{n}. First 6 terms are 0, 1, 2, 36, 4, 36 that \code{n} starting from 0 is conventional choice.
}
\examples{
## generate first 10 numbers of largest values for Juggler sequences
first10 = Juggler.Largest(10)

## print without trailing 0's.
print(first10, drop0trailing = TRUE)

}
\seealso{
\code{\link{Juggler}}
}
