% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deficient.R
\name{Deficient}
\alias{Deficient}
\alias{A005100}
\title{Deficient numbers}
\usage{
Deficient(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A005100}{A005100}, a \emph{deficient} number is
a number whose proper divisors sum up to the extent smaller than the number itself. First
6 abundant numbers are 	1, 2, 3, 4, 5, 7
}
\examples{
## generate first 30 Deficient numbers
first30 = Deficient(30)

## print without trailing 0's.
print(first30, drop0trailing = TRUE)

}
\seealso{
\code{\link{Abundant}}, \code{\link{Perfect}}
}
