% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_methods.R
\name{Phi_fn}
\alias{Phi_fn}
\title{Phi matrix calculation}
\usage{
Phi_fn(samples, derivatives, polyorder = NULL, apriori = NULL)
}
\arguments{
\item{samples}{An \eqn{N} by \eqn{d} matrix of samples from the target}

\item{derivatives}{An \eqn{N} by \eqn{d} matrix of derivatives of the log target with respect to the parameters}

\item{polyorder}{(optional)        The order of the polynomial to be used in the parametric component, with a default of \eqn{1}. We recommend keeping this value low (e.g. only 1-2).}

\item{apriori}{(optional) A vector containing the subset of parameter indices to use in the polynomial. Typically this argument would only be used if the dimension of the problem is very large or if prior information about parameter dependencies is known. The default is to use all parameters \eqn{1:d} where \eqn{d} is the dimension of the target.}
}
\value{
An \eqn{N} by \eqn{Q} matrix (where Q is determined by the polynomial order and the apriori).
}
\description{
This function calculates the \eqn{\Phi} matrix, which is a second order Stein operator applied
to a polynomial. See South et al (2020) for further details. This function is not required for
estimation but may be useful when evaluation samples are not initially available since
estimators using heldout samples are of the form \eqn{mean(f - f_hat) + b[1]} where \eqn{f_hat = K0*a + Phi*b} for heldout K0 and Phi matrices.
}
\references{
South, L. F., Karvonen, T., Nemeth, C., Girolami, M. and Oates, C. J. (2020). Semi-Exact Control Functionals From Sard's Method.  \url{https://arxiv.org/abs/2002.00033}
}
\author{
Leah F. South
}
