% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{class}
\name{xRefClass-class}
\alias{xRefClass}
\alias{xRefClass-class}
\title{Extended Reference Class}
\description{
The Extended Reference Class (xRefClass) inherits directly from \code{envRefClass}. Listed are some of its key features:
\itemize{
\item Method \code{initialize} passes arguments by position or name.
\item Method \code{copy2}, a modified version of \code{copy},
  is tolerant to \code{activeBindingFunction} as fields.
\item Method \code{update} updates a class instance's methods
  according to any update of the class.
}
}
\details{
Extended Reference Class
}
\section{Fields}{

\describe{
\item{\code{.index}}{named_numeric indexes of args}

\item{\code{.default}}{named_list default values of args}

\item{\code{.meta}}{named_list additional args (meta information)}

\item{\code{.envir}}{environment. Default: as.environment(.self)}

\item{\code{.tmp.list}}{list for temporary storage}

\item{\code{.out.list}}{list for outputting}
}}
\section{Methods}{

\describe{
\item{\code{copy2(shallow = FALSE)}}{Modified version of `copy' to allow `activeBindingFunction' as fields.}

\item{\code{update(x)}}{Modify method definition without re-create the class instance. x: character, methods to be updated.}
}}
\examples{
MyClass <-
  setRefClass(
    "MyClass",
    list(
      x="numeric",
      y="numeric",
      z=function(){x+y}
      ),
    contains="xRefClass",
    methods=list(
      initialize=function(...){
        .idx <- c(x=1,y=2)
        callSuper(...,.index=.idx)
      },
      printme=function(){
        cat('Hello World!','\\n')
      }
      )
    )

## Method initialize - pass by position
obj <- MyClass$new(1,2)
obj$x
obj$y

## Method initialize - pass by name
obj <- MyClass$new(y=2)
obj$x
obj$y

## Method copy
## obj <- MyClass$new(1,2)
## obk <- obj$copy()    # Fail!
## ## Error in (function ()  : unused argument (quote("myclass"))

## Method copy2
obj <- MyClass$new(1,2) # No such error!
obk <- obj$copy2()
obk$z

## Method update
obj <- MyClass$new()
obj$printme()
MyClass <- # To modify one of the original functions
  setRefClass(
    "MyClass",
    list(
      x="numeric",
      y="numeric",
      z=function(){x+y}
      ),
    contains="xRefClass",
    methods=list(
      initialize=function(...){
        .idx <- c(x=1,y=2)
        callSuper(...,.index=.idx)
      },
      printme=function(){ # This function is modified
        cat('Hello R!','\\n')
      }
      )
    )
obj$printme() # The function is yet not modified
## Hello World!
obj$update("printme") # update the function
obj$printme() # The function is modified
## Hello R!
}
\author{
Xiaobei Zhao
}
\seealso{
\code{methods::ReferenceClasses}
}

