% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{body_condition_measurements}
\alias{body_condition_measurements}
\title{Humpback whale measurement data from Duke University's Marine Robotics and Remote Sensing (MaRRS) Lab}
\format{
A data frame with 29 rows and 28 columns:
\describe{
  \item{Animal_ID}{unique ID for the individual whale}
  \item{TL}{total body length measurement (m)}
  \item{TL.10.0..Width}{Width of whale (m), pre-computed from pixels using 
        the reported laser altimeter measurement.  Width is taken at a 
        cross-section perpendicular to the whale's center line, running
        from the middle of the rostrum (loosely, the whale's beak/nose) to 
        the middle of the peduncle (the point where the tail connects to the 
        rest of the body).  The cross-section is taken 10% of the distance 
        from the animal's rostrum to its peduncle.}
  \item{TL.15.0..Width}{Same as \code{TL.10.0..Width}, but taken at a 
        cross-section that is 15% of the distance from the animal's rostrum 
        to its peduncle.}
  \item{TL.20.0..Width}{Same as \code{TL.10.0..Width}, but taken at a 
        cross-section that is 20% of the distance from the animal's rostrum 
        to its peduncle.}
  \item{TL.25.0..Width}{Same as \code{TL.10.0..Width}, but taken at a 
        cross-section that is 25% of the distance from the animal's rostrum 
        to its peduncle.}
  \item{TL.30.0..Width}{Same as \code{TL.10.0..Width}, but taken at a 
        cross-section that is 30% of the distance from the animal's rostrum 
        to its peduncle.}
  \item{TL.35.0..Width}{Same as \code{TL.10.0..Width}, but taken at a 
        cross-section that is 35% of the distance from the animal's rostrum 
        to its peduncle.}
  \item{TL.40.0..Width}{Same as \code{TL.10.0..Width}, but taken at a 
        cross-section that is 40% of the distance from the animal's rostrum 
        to its peduncle.}
  \item{TL.45.0..Width}{Same as \code{TL.10.0..Width}, but taken at a 
        cross-section that is 45% of the distance from the animal's rostrum 
        to its peduncle.}
  \item{TL.50.0..Width}{Same as \code{TL.10.0..Width}, but taken at a 
        cross-section that is 50% of the distance from the animal's rostrum 
        to its peduncle.}
  \item{TL.55.0..Width}{Same as \code{TL.10.0..Width}, but taken at a 
        cross-section that is 55% of the distance from the animal's rostrum 
        to its peduncle.}
  \item{TL.60.0..Width}{Same as \code{TL.10.0..Width}, but taken at a 
        cross-section that is 60% of the distance from the animal's rostrum 
        to its peduncle.}
  \item{TL.65.0..Width}{Same as \code{TL.10.0..Width}, but taken at a 
        cross-section that is 65% of the distance from the animal's rostrum 
        to its peduncle.}
  \item{TL.70.0..Width}{Same as \code{TL.10.0..Width}, but taken at a 
        cross-section that is 70% of the distance from the animal's rostrum 
        to its peduncle.}
  \item{TL.75.0..Width}{Same as \code{TL.10.0..Width}, but taken at a 
        cross-section that is 75% of the distance from the animal's rostrum 
        to its peduncle.}
  \item{TL.80.0..Width}{Same as \code{TL.10.0..Width}, but taken at a 
        cross-section that is 80% of the distance from the animal's rostrum 
        to its peduncle.}
  \item{TL.85.0..Width}{Same as \code{TL.10.0..Width}, but taken at a 
        cross-section that is 85% of the distance from the animal's rostrum 
        to its peduncle.}
  \item{TL.90.0..Width}{Same as \code{TL.10.0..Width}, but taken at a 
        cross-section that is 90% of the distance from the animal's rostrum 
        to its peduncle.}
  \item{TL.95.0..Width}{Same as \code{TL.10.0..Width}, but taken at a 
        cross-section that is 95% of the distance from the animal's rostrum 
        to its peduncle.}
  \item{TL.5.0..Width}{Same as \code{TL.10.0..Width}, but taken at a 
        cross-section that is 5% of the distance from the animal's rostrum 
        to its peduncle.}
  \item{Image}{image name}
  \item{BaroAlt}{the barometer altitude adjusted for the launch height of the drone}
  \item{LaserAlt}{the altitude recorded by the laser (LiDAR) altimeter}
  \item{Focal_Length}{focal length of the camera (mm)}
  \item{Iw}{image width (px)} 
  \item{Sw}{sensor width (mm)}
  \item{Aircraft}{the unoccupied aircraft system (UAS), or drone, used in data collection}
}
}
\source{
<https://doi.org/10.3389/fmars.2021.749943>
}
\usage{
body_condition_measurements
}
\description{
Photogrammetric measurements of humpback whales to estimate total body length and body condition.
}
\keyword{datasets}
