/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.data;

import com.miraisolutions.xlconnect.ErrorBehavior;
import com.miraisolutions.xlconnect.data.ColumnBuilder;
import com.miraisolutions.xlconnect.data.DataType;
import com.miraisolutions.xlconnect.utils.CellUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

public class FastColumnBuilder
extends ColumnBuilder {
    public FastColumnBuilder(int nrows, boolean forceConversion, FormulaEvaluator evaluator, ErrorBehavior onErrorCell, String dateTimeFormat) {
        super(nrows, forceConversion, evaluator, onErrorCell, dateTimeFormat);
    }

    @Override
    protected void handleCell(Cell c, CellValue cv) {
        switch (cv.getCellType()) {
            case 3: {
                this.addMissing();
                return;
            }
            case 4: {
                this.addValue(c, cv, DataType.Boolean);
                break;
            }
            case 0: {
                this.addValue(c, cv, DataType.Numeric);
                break;
            }
            case 1: {
                this.addValue(c, cv, DataType.String);
                break;
            }
            case 2: {
                String msg = "Formula detected in already evaluated cell " + CellUtils.formatAsString(c) + "!";
                this.cellError(msg);
                break;
            }
            case 5: {
                String msg = "Error detected in cell " + CellUtils.formatAsString(c) + " - " + CellUtils.getErrorMessage(cv.getErrorValue());
                this.cellError(msg);
                break;
            }
            default: {
                String msg = "Unexpected cell type detected for cell " + CellUtils.formatAsString(c) + "!";
                this.cellError(msg);
            }
        }
    }
}

