/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.crypto;

import javax.crypto.spec.SecretKeySpec;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.poifs.crypt.CryptoFunctions;

public class Biff8XORKey
extends Biff8EncryptionKey {
    final int _xorKey;

    public Biff8XORKey(String password, int xorKey) {
        this._xorKey = xorKey;
        byte[] xorArray = CryptoFunctions.createXorArray1(password);
        this._secretKey = new SecretKeySpec(xorArray, "XOR");
    }

    public static Biff8XORKey create(String password, int xorKey) {
        return new Biff8XORKey(password, xorKey);
    }

    public boolean validate(String password, int verifier) {
        int keyComp = CryptoFunctions.createXorKey1(password);
        int verifierComp = CryptoFunctions.createXorVerifier1(password);
        return this._xorKey == keyComp && verifierComp == verifier;
    }
}

