% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xGRviaGeneAnnoAdv.r
\name{xGRviaGeneAnnoAdv}
\alias{xGRviaGeneAnnoAdv}
\title{Function to conduct region-based enrichment analysis given a list of genomic region sets and a list of ontologies}
\usage{
xGRviaGeneAnnoAdv(list_vec, background = NULL, build.conversion = c(NA,
"hg38.to.hg19", "hg18.to.hg19"), gap.max = 0,
GR.Gene = c("UCSC_knownGene", "UCSC_knownCanonical"),
ontologies = c("GOBP", "GOMF", "GOCC", "PSG", "PS", "PS2", "SF",
"Pfam",
"DO", "HPPA", "HPMI", "HPCM", "HPMA", "MP", "EF", "MsigdbH",
"MsigdbC1",
"MsigdbC2CGP", "MsigdbC2CPall", "MsigdbC2CP", "MsigdbC2KEGG",
"MsigdbC2REACTOME", "MsigdbC2BIOCARTA", "MsigdbC3TFT", "MsigdbC3MIR",
"MsigdbC4CGN", "MsigdbC4CM", "MsigdbC5BP", "MsigdbC5MF", "MsigdbC5CC",
"MsigdbC6", "MsigdbC7", "DGIdb", "GTExV4", "GTExV6", "CreedsDisease",
"CreedsDiseaseUP", "CreedsDiseaseDN", "CreedsDrug", "CreedsDrugUP",
"CreedsDrugDN", "CreedsGene", "CreedsGeneUP", "CreedsGeneDN", "KEGG",
"KEGGmetabolism", "KEGGgenetic", "KEGGenvironmental", "KEGGcellular",
"KEGGorganismal", "KEGGdisease", "REACTOME", "REACTOME_ImmuneSystem",
"REACTOME_SignalTransduction", "CGL"), size.range = c(10, 2000),
min.overlap = 3, which.distance = NULL, test = c("hypergeo", "fisher",
"binomial"), background.annotatable.only = NULL, p.tail = c("one-tail",
"two-tails"), p.adjust.method = c("BH", "BY", "bonferroni", "holm",
"hochberg", "hommel"), ontology.algorithm = c("none", "pc", "elim",
"lea"),
elim.pvalue = 0.01, lea.depth = 2, path.mode = c("all_paths",
"shortest_paths", "all_shortest_paths"), true.path.rule = F, verbose =
T,
silent = FALSE, plot = TRUE, fdr.cutoff = 0.05,
displayBy = c("zscore", "fdr", "pvalue", "fc", "or"),
RData.location = "http://galahad.well.ox.ac.uk/bigdata")
}
\arguments{
\item{list_vec}{an input vector containing genomic regions.
Alternatively it can be a list of vectors, representing multiple groups
of genomic regions. Formatted as "chr:start-end" are genomic regions}

\item{background}{a background vector containing genomic regions
(formatted as "chr:start-end") as the test background. If NULL, by
default all annotatable are used as background}

\item{build.conversion}{the conversion from one genome build to
another. The conversions supported are "hg38.to.hg19" and
"hg18.to.hg19". By default it is NA (no need to do so)}

\item{gap.max}{the maximum distance to nearby genes. Only those genes
no far way from this distance will be considered as nearby genes. By
default, it is 0 meaning that nearby genes are those overlapping with
genomic regions}

\item{GR.Gene}{the genomic regions of genes. By default, it is
'UCSC_knownGene', that is, UCSC known genes (together with genomic
locations) based on human genome assembly hg19. It can be
'UCSC_knownCanonical', that is, UCSC known canonical genes (together
with genomic locations) based on human genome assembly hg19.
Alternatively, the user can specify the customised input. To do so,
first save your RData file (containing an GR object) into your local
computer, and make sure the GR object content names refer to Gene
Symbols. Then, tell "GR.Gene" with your RData file name (with or
without extension), plus specify your file RData path in
"RData.location"}

\item{ontologies}{the ontologies supported currently. It can be "GOBP"
for Gene Ontology Biological Process, "GOMF" for Gene Ontology
Molecular Function, "GOCC" for Gene Ontology Cellular Component, "PSG"
for phylostratigraphy (phylostratific age), "PS" for sTOL-based
phylostratific age information, "PS2" for the collapsed PS version
(inferred ancestors being collapsed into one with the known taxonomy
information), "SF" for SCOP domain superfamilies, "Pfam" for Pfam
domain families, "DO" for Disease Ontology, "HPPA" for Human Phenotype
Phenotypic Abnormality, "HPMI" for Human Phenotype Mode of Inheritance,
"HPCM" for Human Phenotype Clinical Modifier, "HPMA" for Human
Phenotype Mortality Aging, "MP" for Mammalian Phenotype, "EF" for
Experimental Factor Ontology (used to annotate GWAS Catalog genes),
Drug-Gene Interaction database ("DGIdb") for druggable categories,
tissue-specific eQTL-containing genes from GTEx ("GTExV4", "GTExV6p"
and "GTExV7"), crowd extracted expression of differential signatures
from CREEDS ("CreedsDisease", "CreedsDiseaseUP", "CreedsDiseaseDN",
"CreedsDrug", "CreedsDrugUP", "CreedsDrugDN", "CreedsGene",
"CreedsGeneUP" and "CreedsGeneDN"), KEGG pathways (including 'KEGG' for
all, 'KEGGmetabolism' for 'Metabolism' pathways, 'KEGGgenetic' for
'Genetic Information Processing' pathways, 'KEGGenvironmental' for
'Environmental Information Processing' pathways, 'KEGGcellular' for
'Cellular Processes' pathways, 'KEGGorganismal' for 'Organismal
Systems' pathways, and 'KEGGdisease' for 'Human Diseases' pathways),
'REACTOME' for REACTOME pathways or 'REACTOME_x' for its sub-ontologies
(where x can be 'CellCellCommunication', 'CellCycle',
'CellularResponsesToExternalStimuli', 'ChromatinOrganization',
'CircadianClock', 'DevelopmentalBiology', 'DigestionAndAbsorption',
'Disease', 'DNARepair', 'DNAReplication',
'ExtracellularMatrixOrganization', 'GeneExpression(Transcription)',
'Hemostasis', 'ImmuneSystem', 'Metabolism', 'MetabolismOfProteins',
'MetabolismOfRNA', 'Mitophagy', 'MuscleContraction', 'NeuronalSystem',
'OrganelleBiogenesisAndMaintenance', 'ProgrammedCellDeath',
'Reproduction', 'SignalTransduction', 'TransportOfSmallMolecules',
'VesicleMediatedTransport'), and the molecular signatures database
(Msigdb, including "MsigdbH", "MsigdbC1", "MsigdbC2CGP",
"MsigdbC2CPall", "MsigdbC2CP", "MsigdbC2KEGG", "MsigdbC2REACTOME",
"MsigdbC2BIOCARTA", "MsigdbC3TFT", "MsigdbC3MIR", "MsigdbC4CGN",
"MsigdbC4CM", "MsigdbC5BP", "MsigdbC5MF", "MsigdbC5CC", "MsigdbC6",
"MsigdbC7")}

\item{size.range}{the minimum and maximum size of members of each term
in consideration. By default, it sets to a minimum of 10 but no more
than 2000}

\item{min.overlap}{the minimum number of overlaps. Only those terms
with members that overlap with input data at least min.overlap (3 by
default) will be processed}

\item{which.distance}{which terms with the distance away from the
ontology root (if any) is used to restrict terms in consideration. By
default, it sets to 'NULL' to consider all distances}

\item{test}{the test statistic used. It can be "fisher" for using
fisher's exact test, "hypergeo" for using hypergeometric test, or
"binomial" for using binomial test. Fisher's exact test is to test the
independence between gene group (genes belonging to a group or not) and
gene annotation (genes annotated by a term or not), and thus compare
sampling to the left part of background (after sampling without
replacement). Hypergeometric test is to sample at random (without
replacement) from the background containing annotated and non-annotated
genes, and thus compare sampling to background. Unlike hypergeometric
test, binomial test is to sample at random (with replacement) from the
background with the constant probability. In terms of the ease of
finding the significance, they are in order: hypergeometric test >
fisher's exact test > binomial test. In other words, in terms of the
calculated p-value, hypergeometric test < fisher's exact test <
binomial test}

\item{background.annotatable.only}{logical to indicate whether the
background is further restricted to the annotatable. By default, it is
NULL: if ontology.algorithm is not 'none', it is always TRUE;
otherwise, it depends on the background (if not provided, it will be
TRUE; otherwise FALSE). Surely, it can be explicitly stated}

\item{p.tail}{the tail used to calculate p-values. It can be either
"two-tails" for the significance based on two-tails (ie both over- and
under-overrepresentation) or "one-tail" (by default) for the
significance based on one tail (ie only over-representation)}

\item{p.adjust.method}{the method used to adjust p-values. It can be
one of "BH", "BY", "bonferroni", "holm", "hochberg" and "hommel". The
first two methods "BH" (widely used) and "BY" control the false
discovery rate (FDR: the expected proportion of false discoveries
amongst the rejected hypotheses); the last four methods "bonferroni",
"holm", "hochberg" and "hommel" are designed to give strong control of
the family-wise error rate (FWER). Notes: FDR is a less stringent
condition than FWER}

\item{ontology.algorithm}{the algorithm used to account for the
hierarchy of the ontology. It can be one of "none", "pc", "elim" and
"lea". For details, please see 'Note' below}

\item{elim.pvalue}{the parameter only used when "ontology.algorithm" is
"elim". It is used to control how to declare a signficantly enriched
term (and subsequently all genes in this term are eliminated from all
its ancestors)}

\item{lea.depth}{the parameter only used when "ontology.algorithm" is
"lea". It is used to control how many maximum depth is used to consider
the children of a term (and subsequently all genes in these children
term are eliminated from the use for the recalculation of the
signifance at this term)}

\item{path.mode}{the mode of paths induced by vertices/nodes with input
annotation data. It can be "all_paths" for all possible paths to the
root, "shortest_paths" for only one path to the root (for each node in
query), "all_shortest_paths" for all shortest paths to the root (i.e.
for each node, find all shortest paths with the equal lengths)}

\item{true.path.rule}{logical to indicate whether the true-path rule
should be applied to propagate annotations. By default, it sets to
false}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to false for no display}

\item{silent}{logical to indicate whether the messages will be silent
completely. By default, it sets to false. If true, verbose will be
forced to be false}

\item{plot}{logical to indicate whether heatmap plot is drawn}

\item{fdr.cutoff}{fdr cutoff used to declare the significant terms. By
default, it is set to 0.05. This option only works when setting plot
(see above) is TRUE}

\item{displayBy}{which statistics will be used for drawing heatmap. It
can be "fc" for enrichment fold change, "fdr" for adjusted p value (or
FDR), "pvalue" for p value, "zscore" for enrichment z-score (by
default), "or" for odds ratio. This option only works when setting plot
(see above) is TRUE}

\item{RData.location}{the characters to tell the location of built-in
RData files. See \code{\link{xRDataLoader}} for details}
}
\value{
an object of class "ls_eTerm", a list with following components:
\itemize{
\item{\code{df}: a data frame of n x 12, where the 12 columns are
"group" (the input group names), "ontology" (input ontologies), "id"
(term ID), "name" (term name), "nAnno" (number in members annotated by
a term), "nOverlap" (number in overlaps), "fc" (enrichment fold
changes), "zscore" (enrichment z-score), "pvalue" (nominal p value),
"adjp" (adjusted p value (FDR)), "or" (odds ratio), "CIl" (lower bound
confidence interval for the odds ratio), "CIu" (upper bound confidence
interval for the odds ratio), "distance" (term distance or other
information), "members" (members (represented as Gene Symbols) in
overlaps)}
\item{\code{mat}: NULL if the plot is not drawn; otherwise, a matrix of
term names X groups with numeric values for the signficant enrichment,
NA for the insignificant ones}
\item{\code{gp}: NULL if the plot is not drawn; otherwise, a 'ggplot'
object}
}
}
\description{
\code{xGRviaGeneAnnoAdv} is supposed to conduct enrichment analysis
given a list of gene sets and a list of ontologies. It is an advanced
version of \code{xGRviaGeneAnno}, returning an object of the class
'ls_eTerm'.
}
\note{
none
}
\examples{
\dontrun{
# Load the library
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata_dev/"

# Enrichment analysis for GWAS SNPs from ImmunoBase
## a) provide input data (bed-formatted)
data.file <- "http://galahad.well.ox.ac.uk/bigdata/ImmunoBase_GWAS.bed"
input <- read.delim(file=data.file, header=T, stringsAsFactors=F)
data <- paste0(input$chrom, ':', (input$chromStart+1), '-',
input$chromEnd)

# b) perform enrichment analysis
## overlap with gene body
ls_eTerm <- xGRviaGeneAnnoAdv(data, gap.max=0,
ontologies=c("REACTOME_ImmuneSystem","REACTOME_SignalTransduction"),
RData.location=RData.location)
ls_eTerm
## forest plot of enrichment results
gp <- xEnrichForest(ls_eTerm, top_num=10, CI.one=F)
gp
}
}
\seealso{
\code{\link{xRDataLoader}}, \code{\link{xGRviaGeneAnno}},
\code{\link{xEnrichViewer}}, \code{\link{xHeatmap}}
}
