% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distanceCompare.R
\name{distCompare}
\alias{distCompare}
\title{Compares Optimal Transport Distances Between WpProj and Original Models}
\usage{
distCompare(
  models,
  target = list(parameters = NULL, predictions = NULL),
  power = 2,
  method = "exact",
  quantity = c("parameters", "predictions"),
  parallel = NULL,
  transform = function(x) {
     return(x)
 },
  ...
)
}
\arguments{
\item{models}{A list of models from WpProj methods}

\item{target}{The target to compare the methods to. Should be a list with slots "parameters" to compare the parameters and "predictions" to compare predictions}

\item{power}{The power parameter of the Wasserstein distance.}

\item{method}{Which approximation to the Wasserstein distance to use. Should be one of the outputs of \code{\link[=transport_options]{transport_options()}}.}

\item{quantity}{Should the function target the "parameters" or the "predictions". Can choose both.}

\item{parallel}{Parallel backend to use for the \code{foreach} package. See \verb{foreach::registerDoParallel(} for more details.}

\item{transform}{Transformation function for the predictions.}

\item{...}{other options passed to the \code{\link[=wasserstein]{wasserstein()}} distance function}
}
\value{
an object of class \code{distcompare} with slots \code{parameters}, \code{predictions}, and \code{p}. The slots \code{parameters} and \code{predictions} are data frames. See the details for more info. The slot \code{p} is the power parameter of the Wasserstein distance used in the distance calculation.
}
\description{
Compares Optimal Transport Distances Between WpProj and Original Models
}
\details{
For the data frames, \code{dist} is the Wasserstein distance, \code{nactive} is the number of active variables in the model, \code{groups} is the name distinguishing the model, and \code{method} is the method used to calculate the distance (i.e., exact, sinkhorn, etc.). If the list in \code{models} is named, these will be used as the group names otherwise the group names will be created based on the call from the \code{WpProj} method.
}
\examples{
if(rlang::is_installed("stats")) {
n <- 32
p <- 10
s <- 21
x <- matrix( stats::rnorm( p * n ), nrow = n, ncol = p )
beta <- (1:10)/10
y <- x \%*\% beta + stats::rnorm(n)
post_beta <- matrix(beta, nrow=p, ncol=s) + stats::rnorm(p*s, 0, 0.1)
post_mu <- x \%*\% post_beta

fit1 <-  WpProj(X=x, eta=post_mu, power = 2.0,
               options = list(penalty = "lasso")
)
fit2 <-  WpProj(X=x, eta=post_mu, theta = post_beta, power = 2.0,
               method = "binary program", solver = "lasso",
               options = list(solver.options = list(penalty = "mcp"))
)
dc <- distCompare(models = list("L1" = fit1, "BP" = fit2),
                 target = list(parameters = post_beta, predictions = post_mu))
plot(dc)
}
}
