% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/body_add_flextables.R
\name{body_add_flextables}
\alias{body_add_flextables}
\title{Read Word document with bookmarks and create other Word document with rendered tables in place.}
\usage{
body_add_flextables(docxIn, docxOut, flextables, debug = F, ...)
}
\arguments{
\item{docxIn}{String of length one; path to Word file with bookmarks.}

\item{docxOut}{String of length one; path for output Word file.}

\item{flextables}{Named list of flextables; Tables to be inserted into the Word file}

\item{debug}{Boolean of length one; If \code{True} then \code{\link[base]{browser}()} is called at the beginning of the function}

\item{...}{Parameters to be sent to other methods (mainly \code{\link[flextable]{body_add_flextable}})}
}
\value{
Path to the rendered Word file if the operation was successfull.
}
\description{
This function is basically a loop wrapper around \code{\link[flextable]{body_add_flextable}} function.
}
\examples{
library(flextable)
ft_mtcars <- flextable(mtcars)
ft_iris <- flextable(iris)
FT <- list(ft_mtcars=ft_mtcars,ft_iris=ft_iris)
body_add_flextables(
   paste(examplePath(),'templates/templateFT.docx',sep = ''),
   paste(tempdir(),'/resultFT.docx',sep = ''),
   FT)
}
