% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{as_pid}
\alias{as_pid}
\title{Convert an input to a property PID}
\usage{
as_pid(x)
}
\arguments{
\item{x}{a vector, data frame, or tibble of strings representaing wikidata properties}
}
\value{
if the inputted string is a valid PID, return the string.
If the inputted string matches a property label, return its PID.
If the inputted string matches multiple labels of multiple properties, return the PID of the first hit.
}
\description{
Convert an input string to the most likely property PID
}
\examples{
# if input string is a valid PID
as_pid("P50")
# if input string matches multiple item labels
as_pid("author")
# if input string matches a single unique label
as_pid("Scopus author ID")
}
