% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_wblr.R
\name{plotly_wblr}
\alias{plotly_wblr}
\title{Interactive Probability Plot.}
\usage{
plotly_wblr(
  wblr_obj,
  susp = NULL,
  showConf = TRUE,
  showSusp = TRUE,
  showRes = TRUE,
  showGrid = TRUE,
  main = "Probability Plot",
  xlab = "Time to Failure",
  ylab = "Probability",
  probCol = "black",
  fitCol = "black",
  confCol = "black",
  intCol = "black",
  gridCol = "lightgray",
  signif = 3
)
}
\arguments{
\item{wblr_obj}{An object of class 'wblr'. This is a required argument.}

\item{susp}{An optional numeric vector of suspension data. Default is NULL.}

\item{showConf}{Show the confidence bounds (TRUE) or not (FALSE). Default is TRUE if
confidence bounds are available in the wblr object.}

\item{showSusp}{Show the suspensions plot (TRUE) or not (FALSE). Default is TRUE
if susp is provided.}

\item{showRes}{Show the results table (TRUE) or not (FALSE). Default is TRUE.}

\item{showGrid}{Show grid (TRUE) or hide grid (FALSE). Default is TRUE.}

\item{main}{Main title. Default is 'Probability Plot'.}

\item{xlab}{X-axis label. Default is 'Time to Failure'.}

\item{ylab}{Y-axis label. Default is 'Probability'.}

\item{probCol}{Color of the probability values. Default is 'black'.}

\item{fitCol}{Color of the model fit. Default is 'black'.}

\item{confCol}{Color of the confidence bounds. Default is 'black'.}

\item{intCol}{Color of the intervals for interval censored models. Default is 'black'.}

\item{gridCol}{Color of the grid. Default is 'lightgray'.}

\item{signif}{Significant digits of results. Default is 3. Must be a positive integer.}
}
\value{
The function returns no value. It creates an interactive probability plot.
}
\description{
This function creates an interactive probability plot for a wblr object.
It can include confidence bounds, suspension data, and a results table.
}
\examples{
library(WeibullR)
library(WeibullR.plotly)
failures<-c(30, 49, 82, 90, 96)
obj<-wblr.conf(wblr.fit(wblr(failures)))
plotly_wblr(obj)

suspensions<-c(100, 45, 10)
obj<-wblr.conf(wblr.fit(wblr(failures, suspensions)))
plotly_wblr(obj, suspensions, fitCol = 'blue', confCol
= 'blue')
inspection_data <- data.frame(left=c(0, 6.12, 19.92, 29.64, 35.4, 39.72, 45.32, 52.32),
                           right=c(6.12, 19.92, 29.64, 35.4, 39.72, 45.32, 52.32, 63.48),
                           qty=c(5, 16, 12, 18, 18, 2, 6, 17))
suspensions <- data.frame(time = 63.48, event = 0, qty = 73)
obj <- wblr(suspensions, interval = inspection_data)
obj <- wblr.fit(obj, method.fit = "mle")
obj <- wblr.conf(obj, method.conf = "fm", lty = 2)
suspensions <- as.vector(suspensions$time)
plotly_wblr(obj, susp = suspensions, fitCol = 'red', confCol = 'red', intCol = 'blue',
        main = 'Parts Cracking Inspection Interval Analysis',
        ylab =  'Cumulative \% Cracked', xlab='Inspection Time')
failures <- c(25, 30, 42, 49, 55, 67, 73, 82, 90, 96, 101, 110, 120, 132, 145)
fit <- wblr.conf(wblr.fit(wblr(failures), dist = "weibull3p"))
plotly_wblr(fit, fitCol='darkgreen', confCol = 'darkgreen')

}
