% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.effect.MRT3arm}
\alias{wp.effect.MRT3arm}
\title{Effect size calculatator based on raw data for Multisite Randomized Trials with 3 Arms}
\usage{
wp.effect.MRT3arm(file)
}
\arguments{
\item{file}{The input data set.
The first column of the data is the ID variable, the second column represents cluster,
the third column is the outcome variable,
and the fourth column is the condition variable (0 for control, 1 for treatment1, 2 for treatment2).}
}
\value{
A list including effect size f.
}
\description{
This function is for effect size calculation for Multisite randomized trials (MRT) with 3 arms based on empirical data.
MRTs are a type of multilevel design for the situation when the entire cluster is randomly assigned to either a treatment arm or a contral arm \cite{(Liu, 2013)}.
The data from MRT can be analyzed in a two-level hierachical linear model, where the indicator variable for reatment assignment is included in first level. If a study contains multiple treatments, then mutiple indicators will be used.
This function is for designs with 3 arms (i.e., two treatments and a control).
Three types of tests are considered in the function: (1) The "main" type tests treatment main effect;
(2) The "treatment" type tests the difference between the two treaments;
and (3) The "omnibus" type tests whether the three arms are all equivalent.
Details leading to power calculation can be found in \cite{Raudenbush (1997)} and \cite{Liu (2013)}.
This function is used to calculate the effect size with a input data set.
}
\examples{
#To calculate the effect size and ICC based on empirical data
#  wp.effect.MRT3arm(MRT3)
#  Effect size for MRT3arm
#  
#  f1        f2
#  -0.6214215 -0.355098
#  
#  NOTE: f1 for treatment main effect;
#        f2 for comparing the two treatments.
#  URL: http://psychstat.org/mrt3arm

}
\references{
Liu, X. S. (2013). Statistical power analysis for the social and behavioral sciences: basic and advanced techniques. Routledge.

Raudenbush, S. W. (1997). Statistical analysis and optimal design for cluster randomized trials. Psychological Methods, 2(2), 173.
}
