% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoordBase.R, R/RcppExports.R
\name{format}
\alias{format}
\alias{print.coords}
\alias{print.waypoints}
\alias{format.coords}
\alias{format.waypoints}
\alias{ll_headers}
\title{Format and Print Coords or Waypoints}
\usage{
\method{print}{coords}(x, ..., max = NULL)

\method{print}{waypoints}(x, ..., max = NULL)

\method{format}{coords}(x, ..., usenames = TRUE)

\method{format}{waypoints}(x, ..., usenames = TRUE)

ll_headers(aswidth, fmt)
}
\arguments{
\item{x}{object of class \code{"\link{coords}"} created by function \code{\link{as_coords}()}, or
class \code{"\link{waypoints}"} created by function \code{\link{as_waypoints}()}.}

\item{...}{further arguments passed to or from other methods.}

\item{max}{numeric or \code{NULL}, specifying the maximal number of
    entries to be printed.  By default, when \code{NULL},
    \code{\link[base]{getOption}("max.print")} used.}

\item{usenames}{\code{logical}, whether or not to include names in formatted output; default
\code{TRUE}.}

\item{aswidth}{\code{character} vector, used to match width of headers to formatted output.}

\item{fmt}{\code{integer}, \code{1L}, \code{2L} or \code{3L}, specifying the required coordinate
format.}
}
\value{
The \code{format()} methods for both classes \code{"coords"} and \code{"waypoints"} return a
\code{character} vector, respectively of length \code{length(x)} or \code{nrow(x)}, and
containing values formatted in decimal degrees, degrees and minutes, or degrees, minutes and
seconds as appropriate.
}
\description{
Format and print objects of class \code{"coords"} or \code{"waypoints"}.
}
\details{
The \code{format()} methods for \code{"\link{coords}"} and \code{"\link{waypoints}"} objects
output elegantly formatted \code{character} vector representations of their arguments, which are
used by their respective \code{print()} methods.

Prior to formatting and printing, \code{"coords"} or \code{"waypoints"} objects are checked to
ensure that their \code{"valid"} attribute (in the case of a \code{"coords"} object), or
\code{"validlat"} and \code{"validlon"} attributes (in the case of a \code{"waypoints"} object)
are present and all \code{TRUE} i.e., valid. If these attributes are found to contain any
\code{FALSE} i.e. invalid values, a warning is issued and similarly, if these attributes are
missing, a warning is issued and the objects are re-validated as described under
\code{\link{validate}()}.

\code{ll_headers()} outputs the headings \verb{"Latitude ... Longitude"} formatted to the
same width as argument \code{aswidth}, adjusted for format \code{fmt} and is primarily intended
for use by the \code{print()} method for class \code{"waypoints"}.
}
\examples{
## Continuing example from `as_coords()`...
\dontshow{
   dm <-
       c(5130.4659, 4932.7726, 4806.4339, 3853.3696, 0.0000, -3706.7044, -5306.2869, -2514.4093,
	   -007.6754, 1823.9137, -12246.7203, -7702.1145, 0.0000, -1217.3178, 7331.0370, -5731.1536)
   names(dm) <- 
       rep(c("Nelson's Column", "Ostravice", "Tally Ho", "Washington Monument", "Null Island",
             "Tristan da Cunha", "Mawson Peak", "Silvio Pettirossi International Airport"), 2)
   invisible(as_coords(dm, fmt = 2))
   latlon(dm) <- rep(c(TRUE, FALSE), each = 8)
}

## Print named "coords" object in degrees and minutes,
## 'silently' using S3 print() method
dm

## Print explicitly using S3 print() method, specifying
## the maximal number of entries to be printed
print(dm, max = 14)

## Format as a fixed-width character vector,
## with names...
format(dm)

## ...or without them
format(dm, usenames = FALSE)

###
## Continuing example from `as_waypoints()`...
\dontshow{
   wp <- data.frame(
       name = c("Nelson's Column", "Ostravice", "Tally Ho", "Washington Monument", "Null Island",
                "Tristan da Cunha", "Mawson Peak", "Silvio Pettirossi International Airport"),
       lat = c(513027.95, 493246.36, 480626.04, 385322.18, 0, -370642.26, -530617.21, -251424.56),
       lon = c(-00740.53, 182354.82, -1224643.22, -770206.87, 0, -121719.07, 733102.22, -573109.21)
   )
   invisible(as_waypoints(wp, fmt = 3))
}

## Print named "waypoints" object in degrees and minutes,
## 'silently' using S3 print() method
wp

## Print explicitly using S3 print() method, specifying
## the maximal number of entries to be printed
print(wp, max = 21)

## Format as a fixed-width character vector,
## with names...
format(wp)

## ...or without them
format(wp, usenames = FALSE)

rm(dm, wp)


}
\seealso{
\code{\link[base:format]{format}()}, \code{\link[base:print]{print}()},
\code{"\link{coords}"} and \code{"\link{waypoints}"}.
}
\keyword{character}
\keyword{print}
