% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_power_sedrate.R
\name{sum_power_sedrate}
\alias{sum_power_sedrate}
\title{Calculate sum of maximum spectral power for sedimentation rates
for a wavelet spectra}
\usage{
sum_power_sedrate(
  red_noise = NULL,
  wavelet = NULL,
  percentile = NULL,
  sedrate_low = NULL,
  sedrate_high = NULL,
  spacing = NULL,
  cycles = c(NULL),
  x_lab = "depth",
  y_lab = "sedrate",
  run_multicore = FALSE,
  genplot = FALSE,
  plot_res = 1,
  keep_editable = FALSE,
  palette_name = "rainbow",
  color_brewer = "grDevices",
  verbose = FALSE
)
}
\arguments{
\item{red_noise}{Red noise curves generated using the \code{\link{model_red_noise_wt}} function}

\item{wavelet}{Wavelet object created using the \code{\link{analyze_wavelet}} function}

\item{percentile}{Percentile value (0-1) of the rednoise runs which is used to normalize the data for.
To account for the distribution/distortion of the spectral power distribution based on the analytical technique and
random red-noise the data is normalized against a percentile based red-noise curve which is the results of the
'\code{\link{model_red_noise_wt}} modelling runs.}

\item{sedrate_low}{Minimum sedimentation rate (cm/kyr)for which the sum of maximum spectral power is calculated for.}

\item{sedrate_high}{Maximum sedimentation rate (cm/kyr) for which the sum of maximum spectral power is calculated  for.}

\item{spacing}{Spacing (cm/kyr) between sedimentation rates}

\item{cycles}{Astronomical cycles (in kyr) for which the combined sum of maximum spectral power is calculated for}

\item{x_lab}{label for the y-axis \code{Default="depth"}}

\item{y_lab}{label for the y-axis \code{Default="sedrate"}}

\item{run_multicore}{run simulation using multiple cores \code{Default=FALSE}
the simulation is run at x-2 cores to allow the 2 remaining processes to run background processes}

\item{genplot}{Generate plot \code{Default="FALSE"}}

\item{plot_res}{plot options are 1: sum max power or 2: nr of components \code{Default=2}}

\item{keep_editable}{Keep option to add extra features after plotting  \code{Default=FALSE}}

\item{palette_name}{Name of the color palette which is used for plotting.
The color palettes than can be chosen depends on which the R package is specified in
the color_brewer parameter. The included R packages from which palettes can be chosen
from are; the 'RColorBrewer', 'grDevices', 'ColorRamps' and 'Viridis' R packages.
There are many options to choose from so please
read the documentation of these packages \code{Default=rainbow}.
The R package 'viridis' has the color palette options: “magma”, “plasma”,
“inferno”, “viridis”, “mako”, and “rocket”  and “turbo”
To see the color palette options of the The R pacakge 'RColorBrewer' run
the RColorBrewer::brewer.pal.info() function
The R package 'colorRamps' has the color palette options:"blue2green",
"blue2green2red", "blue2red",    "blue2yellow", "colorRamps",    "cyan2yellow",
"green2red", "magenta2green", "matlab.like", "matlab.like2" and    "ygobb"
The R package 'grDevices' has the built in  palette options:"rainbow",
"heat.colors", "terrain.colors","topo.colors" and "cm.colors"
To see even more color palette options of the The R pacakge 'grDevices' run
the grDevices::hcl.pals() function}

\item{color_brewer}{Name of the R package from which the color palette is chosen from.
The included R packages from which palettes can be chosen
are; the RColorBrewer, grDevices, ColorRamps and Viridis R packages.
There are many options to choose from so please
read the documentation of these packages. "\code{Default=grDevices}}

\item{verbose}{Print text \code{Default=FALSE}.}
}
\value{
Returns a list which contains 4 elements
element 1: sum of maximum spectral power
element 2: number of cycles used in the sum of maximum spectral power
element 3: y-axis values of the matrices which is sedimentation rate
element 4: x-axis values of the matrices which is depth

If \code{Default="TRUE"} a plot is created with 3 subplots.
Subplot 1 is plot in which the the sum of maximum spectral power for a
given sedimentation rate or nr of cycles is plotted for each depth given depth.
Subplot 2 is a plot in which the average sum of maximum spectral power is plotted fro each sedimentation
Subplot 3 is a color scale for subplot 1.
}
\description{
The \code{\link{sum_power_sedrate}} function is used calculate the sum of
maximum spectral power for a list of astronomical cycles from a wavelet spectra.
The data is first normalized using the average spectral power curves
 for a given percentile based on results of the \code{\link{model_red_noise_wt}} function
}
\examples{
\donttest{
#estimate sedimentation rate for the the magnetic susceptibility record
# of the Sullivan core of Pas et al., (2018).

mag_wt <- analyze_wavelet(data = mag,
dj = 1/100,
lowerPeriod = 0.1,
upperPeriod = 254,
verbose = FALSE,
omega_nr = 10)

#increase n_simulations to better define the red noise spectral power curve
mag_wt_red_noise <- model_red_noise_wt(wavelet=mag_wt,
n_simulations=10,
run_multicore=FALSE,
verbose=FALSE)

sedrates <- sum_power_sedrate(red_noise=mag_wt_red_noise,
wavelet=mag_wt,
percentile=0.75,
sedrate_low = 0.5,
sedrate_high = 4,
spacing = 0.05,
cycles = c(2376,1600,1180,696,406,110),
x_lab="depth",
y_lab="sedrate",
run_multicore=FALSE,
genplot = FALSE,
plot_res=1,
keep_editable=FALSE,
palette_name = "rainbow",
color_brewer="grDevices",
verbose=FALSE)
}


}
\references{
Routines for astrochronologic testing, astronomical time scale construction, and
time series analysis <doi:10.1016/j.earscirev.2018.11.015>

Acycle: Time-series analysis software for paleoclimate research and education,
Mingsong Li, Linda Hinnov, Lee Kump,
Computers & Geosciences,Volume 127,2019,Pages 12-22,ISSN 0098-3004,
<doi:10.1016/j.cageo.2019.02.011>

Tracking variable sedimentation rates and astronomical forcing in Phanerozoic paleoclimate proxy series with evolutionary correlation coefficients and hypothesis testing,
Mingsong Li, Lee R. Kump, Linda A. Hinnov, Michael E. Mann,
Earth and Planetary Science Letters,Volume 501,
T2018,Pages 165-179,ISSN 0012-821X,<doi:10.1016/j.epsl.2018.08.041>
}
\author{
Based on the \link[astrochron]{asm} and \link[astrochron]{eAsm}
functions of the 'astrochron' R package
and the 'eCOCO' and 'COCO' functions of the 'Acycle' software
}
