% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/winsrch_constrOptim.R
\name{winsrch_constrOptim}
\alias{winsrch_constrOptim}
\alias{winsrch_constrOptim.default}
\title{Find the optimal half-window width combination}
\usage{
winsrch_constrOptim(dat_in, ...)

\method{winsrch_constrOptim}{default}(
  dat_in,
  wins_in = NULL,
  control = list(),
  lower = c(0.1, 1, 0.1),
  upper = c(2, 15, 2),
  ...
)
}
\arguments{
\item{dat_in}{input data object to use with weighted regression}

\item{...}{arguments passed to \code{\link{wrtdscv}}, \code{\link{wrtds}}, or \code{\link{getwts}}}

\item{wins_in}{starting list of window weights for initializing the search algorithm}

\item{control}{A list of control parameters passed to \code{\link[stats]{optim}} (see details in \code{\link[stats]{optim}} help file).}

\item{lower}{vector of minimum half-window widths to evaluate}

\item{upper}{vector of maximum half-window widths to evaluate}
}
\value{
Some stuff
}
\description{
Find the optimal half-window width combination to use for weighted regression.  This differs from \code{\link{winsrch_optim}} by using \code{\link[stats]{constrOptim}}
}
\details{
This function uses \code{\link[stats]{optim}} to minimize the error returned by \code{\link{wrtdscv}} for a given window combination.  The search algorithm uses the limited-memory modification of the BFGS quasi-Newton method to impose upper and lower limits on the optimization search. These limits can be changed using the \code{lower} and \code{upper} arguments.
}
\examples{
\dontrun{
# setup parallel backend
library(doParallel)
ncores <- detectCores() - 1  
registerDoParallel(cores = ncores)

# run search function - takes a while
res <- winsrch_optim(tidobjmean)
}
}
\seealso{
\code{\link{wrtdscv}}, \code{\link{winsrch_grid}}
}
