% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize.R
\name{WMWssp}
\alias{WMWssp}
\title{Sample size calculation for the Wilcoxon-Mann-Whitney test.}
\usage{
WMWssp(x, y, alpha = 0.05, power = 0.8, t = 1/2,
  simulation = FALSE, nsim = 10^4)
}
\arguments{
\item{x}{prior information for the first group}

\item{y}{prior information for the second group}

\item{alpha}{two sided type I error rate}

\item{power}{power}

\item{t}{proportion of subjects in the first group; or use t = "min" to use optimal proportion rate}

\item{simulation}{TRUE if a power simulation should be carried out}

\item{nsim}{number of simulations for the power simulation}
}
\value{
Returns an object from class WMWssp containing

\item{result}{A dataframe with the results.}

\item{t}{The allocation rate which was used.}

\item{alpha}{The type-I error rate which was used.}

\item{simulation}{The achieved power in a simulation.}

\item{power}{The power which was used.}

\item{N}{The sample size needed.}
}
\description{
This function calculates the sample size for a given power, type-I error rate and allocation rate t = n_1/N. Additionally, the actual achieved power can be simulated.
}
\examples{
# Prior information for the reference group
x <- c(315,375,356,374,412,418,445,403,431,410,391,475,379)
# generate data for treatment group based on a shift effect
y <- x - 20

# calculate sample size
ssp <- WMWssp(x, y, alpha = 0.05, power = 0.8, t = 1/2)
summary(ssp)
}
\references{
Brunner, E., Bathke A. C. and Konietschke, F. Rank- and Pseudo-Rank Procedures in Factorial Designs - Using R and SAS. Springer Verlag. to appear.

Happ, M., Bathke, A. C., & Brunner, E. (2019). Optimal Sample Size Planning for the Wilcoxon-Mann-Whitney-Test. Statistics in medicine, 38(3), 363-375.
}
\keyword{export}
