% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WL.R
\name{WL}
\alias{WL}
\title{Statistical inference in weighted Lindley distribution}
\usage{
WL(
  x,
  est_method = "MLEc",
  bias_cor = "None",
  dist_test = "ks",
  gof_alpha = 0.05,
  ks_side = "two",
  CI_method = "asymp",
  CI_scale = "normal",
  CI_side = "two",
  CI_alpha = 0.05,
  boots_iter = 10^3,
  wilks_test = TRUE,
  wilks_alpha = 0.05,
  wilks_side = "two"
)
}
\arguments{
\item{x}{a numeric vector or data frame.}

\item{est_method}{a character string which selects the estimation method
("MME", "MMEm", "MLE", "MLEc"), default is "MLEc".}

\item{bias_cor}{an optional character character string which selects the bias correction method
("coxsnell", "boots" or "firth").}

\item{dist_test}{a character string or character vector which choose the test of goodness of fit
("all","ks","ad","cvm").}

\item{gof_alpha}{a numeric value between 0 and 1 for controlling the significance level
of goodness of fit test; default value is 0.05.}

\item{ks_side}{a character string which selects the alternative hypothesis
("two", "less" or "greater") for Kolmogorov-Smirnov Test, default is "two".}

\item{CI_method}{a character string which selects the method for calculating
confidence intervals ("asymp" or "boots"), default is "asymp".
Since the "asymp" option is not available with bias correction, only the "boots" is available
with bias correction.}

\item{CI_scale}{a character string which selects the scale of confidence intervals ("exp" or "normal")}

\item{CI_side}{a character string which selects the direction of confidence intervals
("two", "less" or "greater").}

\item{CI_alpha}{a numeric value between 0 and 1 for controlling the significance level
of confidence intervals; default value is 0.05.}

\item{boots_iter}{a numeric value for iteration number of bootstrap method.}

\item{wilks_test}{logical. If \code{TRUE}, wilks' theorem test is performed.}

\item{wilks_alpha}{a numeric value between 0 and 1 for controlling the significance level
of wilks' theorem test; default value is 0.05.}

\item{wilks_side}{a character string which selects the direction of wilks' theorem test
("two", "less" or "greater").}
}
\value{
\code{WL} returns a list with these components:
\item{data}{a numeric vector the input values.}
\item{dataname}{a character string the name of input values.}
\item{stat_summary}{a numeric vector with min, 1st quantile, median, 3rd quantile, and max.}
\item{mean}{a numeric value mean of input values.}
\item{var}{a numeric value variance of input values.}
\item{est}{a numeric vector with estimated lambda and phi.}
\item{lambda_var}{a numeric value variance of estimated lambda.}
\item{phi_var}{a numeric value variance of estimationed lambda.}
\item{bias_cor}{a character string from bias correction method ("coxsnell","firth" or "boots").}
\item{est_method}{a character string from estimation method ("MME", "MMEm", "MLE" or "MLEc").}
\item{boots_iter}{a numeric value of bootstrap iteration.}
\item{test_list}{a list with results of goodness of fit test.}
\item{CI_list}{a list with confidence interval related outputs.}
\item{wilks_list}{a list with results of wilks' test.}
}
\description{
Weighted Lindley distribution is suggested by Ghitany et al. (2011). \code{WL} provides four types of
estimator, which are MME, modified MME, MLE, and MLEc from weighted Lindley distribution.
And there are four sub-options, which are bias-correction, goodness of fit test, confidence interval,
and Wilks' theorem test.
}
\details{
First, the user can determine the type of estimator from MME, modified MME, MLE, and MLEc.
The closed form formulas for MME, modified MME, and MLEc are given in Hyoung-Moon Kim. et al. (2020).
And MLE is obtained numerically. Additionally MLE and MLEc have bias correction options.
MLE has Cox&Snell method and Firth's method, however MLEc has Cox&Snell method and bootstrap method.\cr

Second, it provides a goodness of fit test. There are three kinds of tests, Kolmogorov-Smirnov test,
Anderson Darling test, and Cramer-von Mises test. They provide statistics and also p-values.
If the input value \code{gof_alpha} is selected, it determines whether or not to reject the null hypothesis.
\cr

Third, it provides information on the confidence interval. There are two kinds of confidence intervals,
one is based on bootstrap method, and the other is asymptotic variance based method.
Asymptotic variance based method is only available without bias correction, however bootstrap method is
always available. Sometimes the confidence interval is outside the parameter space. If it occers,
confidence interval will be calculated with log scale and show the exponential confidence interval of log
scaled estimators. This option can also be used separately with selecting "exp" in \code{CI_scale}.

Lastly, through \code{wilks.test}, \code{WL} test the parameter space of estimators lambda and phi.
There is an option for Wilks' theorem test, and that option provides options for the side of
Wilks' theorem test.
}
\examples{
example <- lifetime_alum
result <- WL(example)
print(result)

}
\references{
Ghitany, M., Alqallaf, F., Al-Mutairi, D., Husain, H. (2011). A two-parameter weighted
Lindley distribution and its applications to survival data. \emph{Mathematics and Computers in
Simulation} 81: 1190-1201.

Hyoung-Moon Kim. and Yu-Hyeong Jang. (2020). New Closed-Form Estimators for
Weighted Lindley Distribution. \emph{ }, submitted.

Wang, M., Wang, W. (2017). Bias-Corrected maximum likelihood estimation of the parameters
of the weighted Lindley distribution. \emph{Communications in Statistics
Simulation and Computation} 46: 530-545.
}
